/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.core.world;

import java.io.Serializable;
import mrtjp.core.math.PerlinNoiseGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IPlantable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class WorldLib$ {
    public static final WorldLib$ MODULE$ = new WorldLib$();
    private static final PerlinNoiseGenerator noise = new PerlinNoiseGenerator(2576710L);

    public void bulkBlockUpdate(World world, BlockPos pos, Block bl) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)a -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)b -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)c -> {
            block0: {
                int md = (a < 0 ? -a : a) + (b < 0 ? -b : b) + (c < 0 ? -c : c);
                if (md > 3) break block0;
                BlockPos pos2 = new BlockPos(pos.func_177958_n() + a, pos.func_177956_o() + b, pos.func_177952_p() + c);
                world.func_190524_a(pos2, bl, pos);
            }
        })));
    }

    public void dropItem(World world, BlockPos pos, ItemStack stack) {
        block0: {
            if (world.field_72995_K || !world.func_82736_K().func_223586_b(GameRules.field_223603_f)) break block0;
            double d = 0.7;
            double dx = (double)world.field_73012_v.nextFloat() * d + (1.0 - d) * 0.5;
            double dy = (double)world.field_73012_v.nextFloat() * d + (1.0 - d) * 0.5;
            double dz = (double)world.field_73012_v.nextFloat() * d + (1.0 - d) * 0.5;
            ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack);
            item.func_174867_a(10);
            world.func_217376_c((Entity)item);
        }
    }

    public void centerEject(World w, BlockPos pos, ItemStack stack, int dir, double vel) {
        BlockPos pos2 = pos.func_177972_a(Direction.values()[dir]);
        ItemEntity item = new ItemEntity(w, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5, stack);
        item.func_174867_a(10);
        double motionY = 0.0;
        double motionZ = 0.0;
        double motionX = 0.0;
        int n = dir;
        switch (n) {
            case 0: {
                motionY = -vel;
                break;
            }
            case 1: {
                motionY = vel;
                break;
            }
            case 2: {
                motionZ = -vel;
                break;
            }
            case 3: {
                motionZ = vel;
                break;
            }
            case 4: {
                motionX = -vel;
                break;
            }
            case 5: {
                motionX = vel;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        item.func_213293_j(motionX, motionY, motionZ);
        w.func_217376_c((Entity)item);
    }

    public boolean hasItem(BlockState state) {
        ItemStack s = new ItemStack((IItemProvider)state.func_177230_c());
        return !s.func_190926_b();
    }

    public boolean isPlantType(World world, BlockPos pos, BlockState state) {
        Block block;
        Block block2 = state.func_177230_c();
        boolean bl = block2 instanceof IGrowable ? !((block = block2) instanceof GrassBlock) : block2 instanceof IPlantable;
        return bl;
    }

    public boolean isBlockTouchingAir(World world, BlockPos pos) {
        boolean bl;
        Object object = new Object();
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)s -> {
                if (world.func_175623_d(pos.func_177972_a(Direction.values()[s]))) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public int getSkyLightValue(World world, BlockPos pos) {
        return world.func_226658_a_(LightType.SKY, pos) - world.func_175657_ab();
    }

    public int getBlockLightValue(World w, BlockPos pos) {
        return w.func_226658_a_(LightType.BLOCK, pos);
    }

    private PerlinNoiseGenerator noise() {
        return noise;
    }

    /*
     * WARNING - void declaration
     */
    public double getWindSpeed(World world, BlockPos pos) {
        void var3_3;
        double nv = this.noise().noise((double)world.func_72820_D() * 8.5E-7, 0.0, 0.0, 5, 7.5, 5.0, true);
        nv = package$.MODULE$.max(0.0, 1.6 * (nv - 0.006) + 0.06) * package$.MODULE$.sqrt((double)pos.func_177956_o()) / 16.0;
        Biome bgb = world.func_226691_t_(pos);
        Biome.RainType rainType = bgb.func_201851_b();
        Biome.RainType rainType2 = Biome.RainType.RAIN;
        if (!(rainType != null ? !rainType.equals(rainType2) : rainType2 != null)) {
            if (world.func_72911_I()) {
                return 2.5 * nv;
            }
            if (world.func_72896_J()) {
                return 0.5 + 0.5 * nv;
            }
        }
        return (double)var3_3;
    }

    private WorldLib$() {
    }
}

