/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import shadows.placebo.patreon.wings.IWingModel;
import shadows.placebo.patreon.wings.Wing;

public class PatreonUtils {
    public static final KeyBinding TOGGLE_T = new KeyBinding("placebo.toggleTrails", 328, "key.categories.placebo");
    public static final KeyBinding TOGGLE_W = new KeyBinding("placebo.toggleWings", 329, "key.categories.placebo");
    public static final ResourceLocation ANGEL_TEX = new ResourceLocation("placebo", "textures/wings/angel.png");
    public static final ResourceLocation BAT_TEX = new ResourceLocation("placebo", "textures/wings/bat.png");
    public static final ResourceLocation DEMON_TEX = new ResourceLocation("placebo", "textures/wings/demon.png");
    public static final ResourceLocation FLY_TEX = new ResourceLocation("placebo", "textures/wings/fly.png");
    public static final ResourceLocation PIXIE_TEX = new ResourceLocation("placebo", "textures/wings/pixie.png");
    public static final ResourceLocation SPOOKY_TEX = new ResourceLocation("placebo", "textures/wings/spooky.png");

    public static enum WingType {
        ANGEL(() -> Wing.INSTANCE, p -> ANGEL_TEX, -0.5),
        BAT(() -> Wing.INSTANCE, p -> BAT_TEX, -0.7),
        DEMON(() -> Wing.INSTANCE, p -> DEMON_TEX, -0.55),
        FLY(() -> Wing.INSTANCE, p -> FLY_TEX, -0.58),
        PIXIE(() -> Wing.INSTANCE, p -> PIXIE_TEX, -0.65),
        SPOOKY(() -> Wing.INSTANCE, p -> SPOOKY_TEX, -0.65);

        public final Supplier<IWingModel> model;
        public final Function<PlayerEntity, ResourceLocation> textureGetter;
        public final double yOffset;

        private WingType(Supplier<IWingModel> model, Function<PlayerEntity, ResourceLocation> textureGetter, double yOffset) {
            this.model = model;
            this.textureGetter = textureGetter;
            this.yOffset = yOffset;
        }
    }

    public static enum PatreonParticleType {
        SOUL_FIRE(() -> ParticleTypes.field_239811_B_),
        FIRE(() -> ParticleTypes.field_197631_x),
        CAMPFIRE_SMOKE(() -> ParticleTypes.field_218417_ae),
        CLOUD(() -> ParticleTypes.field_197613_f),
        GROWTH(() -> ParticleTypes.field_197632_y),
        DMG_HEART(() -> ParticleTypes.field_197615_h),
        HEART(() -> ParticleTypes.field_197633_z),
        DRAGON_BREATH(() -> ParticleTypes.field_197616_i),
        END_ROD(() -> ParticleTypes.field_197624_q),
        FIREWORK(() -> ParticleTypes.field_197629_v),
        SLIME(() -> ParticleTypes.field_197592_C),
        SNOW(() -> ParticleTypes.field_197593_D),
        SOUL(() -> ParticleTypes.field_239812_C_),
        WITCH(() -> ParticleTypes.field_197607_R);

        public final Supplier<IParticleData> type;

        private PatreonParticleType(Supplier<IParticleData> type) {
            this.type = type;
        }
    }
}

