/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.EnchantRandomly;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import shadows.placebo.loot.StackLootEntry;

public class ChestBuilder {
    protected Random random;
    protected ChestTileEntity chest;
    protected boolean isValid;
    protected BlockPos position;
    protected IWorld iWorld;

    public ChestBuilder(IWorld world, Random rand, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ChestTileEntity) {
            this.random = rand;
            this.chest = (ChestTileEntity)tileEntity;
            this.isValid = true;
            this.position = pos;
            this.iWorld = world;
        }
    }

    public void fill(ResourceLocation loot) {
        if (this.iWorld != null) {
            LockableLootTileEntity.func_195479_a((IBlockReader)this.iWorld, (Random)this.random, (BlockPos)this.position, (ResourceLocation)loot);
        } else {
            this.chest.func_189404_a(loot, this.random.nextLong());
        }
    }

    public static LootEntry loot(Item item, int min, int max, int weight, int quality) {
        return ChestBuilder.loot(new ItemStack((IItemProvider)item), min, max, weight, quality);
    }

    public static LootEntry loot(Block block, int min, int max, int weight, int quality) {
        return ChestBuilder.loot(new ItemStack((IItemProvider)block), min, max, weight, quality);
    }

    public static LootEntry loot(ItemStack item, int min, int max, int weight, int quality) {
        return new StackLootEntry(item, min, max, weight, quality);
    }

    public static void place(IWorld world, Random random, BlockPos pos, ResourceLocation loot) {
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P(), 2);
        ChestBuilder chest = new ChestBuilder(world, random, pos);
        if (chest.isValid) {
            chest.fill(loot);
        }
    }

    public static void placeTrapped(IWorld world, Random random, BlockPos pos, ResourceLocation loot) {
        world.func_180501_a(pos, Blocks.field_150447_bR.func_176223_P(), 2);
        ChestBuilder chest = new ChestBuilder(world, random, pos);
        if (chest.isValid) {
            chest.fill(loot);
        }
    }

    public static class EnchantedEntry
    extends StackLootEntry {
        protected final ILootFunction func = EnchantRandomly.func_215900_c().func_216052_b();
        protected Item i;

        public EnchantedEntry(Item i, int weight) {
            super(new ItemStack((IItemProvider)i), 1, 1, weight, 5, new ILootCondition[0], new ILootFunction[]{EnchantRandomly.func_215900_c().func_216052_b()});
            this.i = i;
        }
    }
}

