/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;

@Deprecated
public class TagBuilder {
    public static final String HAND_ITEMS = "HandItems";
    public static final String ARMOR_ITEMS = "ArmorItems";
    public static final String PASSENGERS = "Passengers";
    public static final String PERSISTENT = "PersistenceRequired";
    public static final String HEALTH = "Health";
    public static final String OFFSET = "Offset";
    public static final String MOTION = "Motion";
    public static final String DIRECTION = "direction";
    public static final String ENTITY_FIRE = "Fire";
    public static final String ARROW_PICKUP = "pickup";
    public static final String ARROW_DAMAGE = "damage";
    public static final CompoundNBT ARROW = TagBuilder.getDefaultTag((EntityType<? extends Entity>)EntityType.field_200790_d);
    public static final String EFFECTS = "ActiveEffects";
    public static final String TIME = "Time";
    public static final String DROP_ITEM = "DropItem";
    public static final String HURT_ENTITIES = "HurtEntities";
    public static final String FALL_HURT_AMOUNT = "FallHurtAmount";
    public static final String FALL_HURT_MAX = "FallHurtMax";
    public static final String TILE_ENTITY_DATA = "TileEntityData";
    public static final CompoundNBT TNT = TagBuilder.getDefaultTag((EntityType<? extends Entity>)EntityType.field_200735_aa);
    public static final String FUSE = "Fuse";

    public static CompoundNBT getDefaultTag(EntityType<? extends Entity> entity) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", entity.getRegistryName().toString());
        return tag;
    }

    public static CompoundNBT setHealth(CompoundNBT entity, float health) {
        entity.func_74776_a(HEALTH, health);
        return entity;
    }

    public static CompoundNBT setPersistent(CompoundNBT entity, boolean persistent) {
        entity.func_74757_a(PERSISTENT, persistent);
        return entity;
    }

    public static CompoundNBT setEquipment(CompoundNBT entity, ItemStack ... equipment) {
        ItemStack[] stacks = TagBuilder.fixStacks(equipment);
        ListNBT tagListHands = new ListNBT();
        for (int i = 0; i < 2; ++i) {
            tagListHands.add((Object)new CompoundNBT());
        }
        ListNBT tagListArmor = new ListNBT();
        for (int i = 0; i < 4; ++i) {
            tagListArmor.add((Object)new CompoundNBT());
        }
        for (EquipmentSlotType s : EquipmentSlotType.values()) {
            ItemStack stack = stacks[s.ordinal()];
            if (s.func_188453_a() == EquipmentSlotType.Group.HAND && !stack.func_190926_b()) {
                tagListHands.set(s.func_188454_b(), (INBT)stack.func_77955_b(new CompoundNBT()));
                continue;
            }
            if (stack.func_190926_b()) continue;
            tagListArmor.set(s.func_188454_b(), (INBT)stack.func_77955_b(new CompoundNBT()));
        }
        entity.func_218657_a(HAND_ITEMS, (INBT)tagListHands);
        entity.func_218657_a(ARMOR_ITEMS, (INBT)tagListArmor);
        return entity;
    }

    private static ItemStack[] fixStacks(ItemStack[] unfixed) {
        ItemStack[] stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
        for (int i = 0; i < unfixed.length; ++i) {
            if (unfixed[i] == null) continue;
            stacks[i] = unfixed[i];
        }
        return stacks;
    }

    public static CompoundNBT setDropChances(CompoundNBT entity, float ... chances) {
        float[] fixed = TagBuilder.fixChances(chances);
        ListNBT tagListHands = new ListNBT();
        ListNBT tagListArmor = new ListNBT();
        for (EquipmentSlotType s : EquipmentSlotType.values()) {
            FloatNBT chance = FloatNBT.func_229689_a_((float)fixed[s.ordinal()]);
            if (s.func_188453_a() == EquipmentSlotType.Group.HAND) {
                tagListHands.set(s.func_188454_b(), (INBT)chance);
                continue;
            }
            tagListArmor.set(s.func_188454_b(), (INBT)chance);
        }
        entity.func_218657_a(HAND_ITEMS, (INBT)tagListHands);
        entity.func_218657_a(ARMOR_ITEMS, (INBT)tagListArmor);
        return entity;
    }

    private static float[] fixChances(float[] unfixed) {
        float[] chances = new float[6];
        for (int i = 0; i < unfixed.length; ++i) {
            chances[i] = unfixed[i];
        }
        return chances;
    }

    public static CompoundNBT setOffset(CompoundNBT entity, double x, double y, double z) {
        entity.func_218657_a(OFFSET, (INBT)TagBuilder.doubleTagList(x, y, z));
        return entity;
    }

    public static CompoundNBT setMotion(CompoundNBT entity, double x, double y, double z) {
        entity.func_218657_a(MOTION, (INBT)TagBuilder.doubleTagList(x, y, z));
        return entity;
    }

    public static CompoundNBT setFireballMotion(CompoundNBT entity, double x, double y, double z) {
        entity.func_218657_a(DIRECTION, (INBT)TagBuilder.doubleTagList(x, y, z));
        return entity;
    }

    public static ListNBT doubleTagList(double ... data) {
        ListNBT tagList = new ListNBT();
        for (double d : data) {
            tagList.add((Object)DoubleNBT.func_229684_a_((double)d));
        }
        return tagList;
    }

    public static ItemStack addPotionEffect(ItemStack stack, Effect potion, int duration, int amplifier) {
        return PotionUtils.func_185184_a((ItemStack)stack, Arrays.asList(new EffectInstance(potion, duration, amplifier)));
    }

    public static void addPotionEffect(CompoundNBT tag, Effect potion, int amplifier) {
        TagBuilder.addPotionEffect(tag, potion, Integer.MAX_VALUE, amplifier, false);
    }

    public static void addPotionEffect(CompoundNBT tag, Effect potion, int amplifier, boolean showParticles) {
        TagBuilder.addPotionEffect(tag, potion, Integer.MAX_VALUE, amplifier, showParticles);
    }

    public static void addPotionEffect(CompoundNBT tag, Effect potion, int duration, int amplifier) {
        TagBuilder.addPotionEffect(tag, potion, duration, amplifier, false);
    }

    public static CompoundNBT addPotionEffect(CompoundNBT entity, Effect potion, int duration, int amplifier, boolean showParticles) {
        ListNBT effects = entity.func_150295_c(EFFECTS, 10);
        EffectInstance fx = new EffectInstance(potion, duration, amplifier, false, showParticles);
        effects.add((Object)fx.func_82719_a(new CompoundNBT()));
        entity.func_218657_a(EFFECTS, (INBT)effects);
        return entity;
    }

    public static CompoundNBT fallingBlock(BlockState state, int time) {
        return TagBuilder.fallingBlock(state, time, false, 2.0f, 40, false, null);
    }

    public static CompoundNBT fallingBlock(BlockState state, int time, float fallDamage) {
        return TagBuilder.fallingBlock(state, time, true, fallDamage, 40, false, null);
    }

    public static CompoundNBT fallingBlock(BlockState state, int time, boolean hurtEntities, float fallDamage, int maxFallDamage, boolean dropItem, CompoundNBT tileData) {
        CompoundNBT tag = TagBuilder.getDefaultTag((EntityType<? extends Entity>)EntityType.field_200809_w);
        tag.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)state));
        tag.func_74768_a(TIME, time);
        tag.func_74757_a(DROP_ITEM, dropItem);
        tag.func_74757_a(HURT_ENTITIES, hurtEntities);
        tag.func_74776_a(FALL_HURT_AMOUNT, fallDamage);
        tag.func_74768_a(FALL_HURT_MAX, maxFallDamage);
        if (tileData != null) {
            tag.func_218657_a(TILE_ENTITY_DATA, (INBT)tileData);
        }
        return tag;
    }

    public static CompoundNBT applyTNTHat(CompoundNBT tag) {
        TagBuilder.setMotion(tag, 0.0, 0.3, 0.0);
        TagBuilder.addPotionEffect(tag, Effects.field_76424_c, 1);
        TagBuilder.addPotionEffect(tag, Effects.field_76429_m, -6);
        TagBuilder.addPassengers(tag, TNT.func_74737_b());
        return tag;
    }

    public static CompoundNBT addPassengers(CompoundNBT entity, CompoundNBT ... passengers) {
        ListNBT list = entity.func_150295_c(PASSENGERS, 10);
        if (list.isEmpty()) {
            entity.func_218657_a(PASSENGERS, (INBT)list);
        }
        for (CompoundNBT nbt : passengers) {
            list.add((Object)nbt);
        }
        return entity;
    }

    public static CompoundNBT checkForSkeleton(CompoundNBT entity) {
        if (entity.func_74779_i("id").contains("skeleton")) {
            TagBuilder.setEquipment(entity, new ItemStack((IItemProvider)Items.field_151031_f));
        }
        return entity;
    }

    public static CompoundNBT checkForCreeper(CompoundNBT entity) {
        if (entity.func_74779_i("id").contains("creeper")) {
            ListNBT effects = entity.func_150295_c(EFFECTS, 10);
            for (INBT nbt : effects) {
                ((CompoundNBT)nbt).func_74768_a("Duration", 300);
            }
            return entity;
        }
        return entity;
    }
}

