/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.model.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.item.ItemEffectHandler;
import me.ichun.mods.ichunutil.client.model.item.IModel;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;

public class ItemModelRenderer
implements IBakedModel {
    private static final List<BakedQuad> EMPTY_LIST = Collections.emptyList();
    @Nonnull
    private final IModel model;

    public <T extends ItemStackTileEntityRenderer> ItemModelRenderer(@Nonnull T renderer) {
        this.model = (IModel)renderer;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return EMPTY_LIST;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(MissingTextureSprite.func_195675_b());
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model.getCameraTransforms();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack stack) {
        this.model.handlePerspective(cameraTransformType, stack);
        if (this.model.isDualHanded()) {
            boolean isLeft = ItemModelRenderer.isLeftHand(cameraTransformType);
            if (ItemModelRenderer.isFirstPerson(cameraTransformType) && ItemEffectHandler.dualHandedAnimationRight > 0) {
                float prog = (float)Math.sin((double)MathHelper.func_76131_a((float)((isLeft ? MathHelper.func_219799_g((float)iChunUtil.eventHandlerClient.partialTick, (float)ItemEffectHandler.prevDualHandedAnimationLeft, (float)ItemEffectHandler.dualHandedAnimationLeft) : MathHelper.func_219799_g((float)iChunUtil.eventHandlerClient.partialTick, (float)ItemEffectHandler.prevDualHandedAnimationRight, (float)ItemEffectHandler.dualHandedAnimationRight)) / (float)ItemEffectHandler.dualHandedAnimationTime), (float)0.0f, (float)1.0f) * Math.PI / 4.0);
                stack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(30.0f * prog));
                stack.func_227861_a_(0.0, (double)(-0.1f * prog), (double)(0.3f * prog));
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(35.0f * prog));
            }
        }
        ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)stack);
        return this;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideListHandler.INSTANCE.setItemModel(this);
    }

    public static boolean isFirstPerson(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
    }

    public static boolean isThirdPerson(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isEntityRender(ItemCameraTransforms.TransformType type) {
        return ItemModelRenderer.isFirstPerson(type) || ItemModelRenderer.isThirdPerson(type);
    }

    public static boolean isLeftHand(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
    }

    public static boolean isRightHand(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isItemRender(ItemCameraTransforms.TransformType type) {
        return type == null || type == ItemCameraTransforms.TransformType.HEAD || type == ItemCameraTransforms.TransformType.GUI || type == ItemCameraTransforms.TransformType.GROUND || type == ItemCameraTransforms.TransformType.NONE;
    }

    private static final class ItemOverrideListHandler
    extends ItemOverrideList {
        private static final ItemOverrideListHandler INSTANCE = new ItemOverrideListHandler();
        private ItemModelRenderer itemModel;

        private ItemOverrideListHandler() {
        }

        private ItemOverrideListHandler setItemModel(ItemModelRenderer itemModel) {
            this.itemModel = itemModel;
            return this;
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            this.itemModel.model.handleItemState(stack, world, entity);
            return originalModel;
        }
    }
}

