/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.tabula.legacy.project;

@Deprecated
public class TechneConverter {
    public static Rotation fromTechne(Rotation rotation) {
        Matrix3x3 rotationMatrixX = Matrix3x3.createRotationMatrixX(rotation.getRadiansX());
        Matrix3x3 rotationMatrixY = Matrix3x3.createRotationMatrixY(rotation.getRadiansY());
        Matrix3x3 rotationMatrixZ = Matrix3x3.createRotationMatrixZ(rotation.getRadiansZ());
        Matrix3x3 combinedRotation = rotationMatrixY.multiply(rotationMatrixZ).multiply(rotationMatrixX);
        return Rotation.createFromMatrixZYX(combinedRotation);
    }

    public static Rotation toTechne(Rotation rotation) {
        Matrix3x3 rotationMatrixX = Matrix3x3.createRotationMatrixX(rotation.getRadiansX());
        Matrix3x3 rotationMatrixY = Matrix3x3.createRotationMatrixY(rotation.getRadiansY());
        Matrix3x3 rotationMatrixZ = Matrix3x3.createRotationMatrixZ(rotation.getRadiansZ());
        Matrix3x3 combinedRotation = rotationMatrixZ.multiply(rotationMatrixY).multiply(rotationMatrixX);
        return Rotation.createFromMatrixYZX(combinedRotation);
    }

    private TechneConverter() {
    }

    public static class Rotation {
        private double rotationX;
        private double rotationY;
        private double rotationZ;

        private Rotation(double rotationX, double rotationY, double rotationZ) {
            this.rotationX = rotationX;
            this.rotationY = rotationY;
            this.rotationZ = rotationZ;
        }

        public static Rotation createFromRadians(double rotationX, double rotationY, double rotationZ) {
            return new Rotation(rotationX, rotationY, rotationZ);
        }

        public static Rotation createFromDegrees(double rotationX, double rotationY, double rotationZ) {
            return new Rotation(Math.toRadians(rotationX), Math.toRadians(rotationY), Math.toRadians(rotationZ));
        }

        public double getRadiansX() {
            return this.rotationX;
        }

        public double getRadiansY() {
            return this.rotationY;
        }

        public double getRadiansZ() {
            return this.rotationZ;
        }

        public double getDegreesX() {
            return Math.toDegrees(this.rotationX);
        }

        public double getDegreesY() {
            return Math.toDegrees(this.rotationY);
        }

        public double getDegreesZ() {
            return Math.toDegrees(this.rotationZ);
        }

        public static Rotation createFromMatrixZYX(Matrix3x3 matrix) {
            Rotation result = new Rotation(0.0, 0.0, 0.0);
            if (matrix.getValue(0, 2) < 1.0) {
                if (matrix.getValue(0, 2) > -1.0) {
                    result.rotationY = Math.asin(-matrix.getValue(0, 2));
                    result.rotationZ = Math.atan2(matrix.getValue(0, 1), matrix.getValue(0, 0));
                    result.rotationX = Math.atan2(matrix.getValue(1, 2), matrix.getValue(2, 2));
                } else {
                    result.rotationY = 1.5707963267948966;
                    result.rotationZ = -Math.atan2(-matrix.getValue(2, 1), matrix.getValue(1, 1));
                    result.rotationX = 0.0;
                }
            } else {
                result.rotationY = -1.5707963267948966;
                result.rotationZ = Math.atan2(-matrix.getValue(2, 1), matrix.getValue(1, 1));
                result.rotationX = 0.0;
            }
            return result;
        }

        public static Rotation createFromMatrixYZX(Matrix3x3 matrix) {
            Rotation result = new Rotation(0.0, 0.0, 0.0);
            if (matrix.getValue(0, 1) < 1.0) {
                if (matrix.getValue(0, 1) > -1.0) {
                    result.rotationZ = Math.asin(matrix.getValue(0, 1));
                    result.rotationY = Math.atan2(-matrix.getValue(0, 2), matrix.getValue(0, 0));
                    result.rotationX = Math.atan2(-matrix.getValue(2, 1), matrix.getValue(1, 1));
                } else {
                    result.rotationZ = -1.5707963267948966;
                    result.rotationY = -Math.atan2(matrix.getValue(1, 2), matrix.getValue(2, 2));
                    result.rotationX = 0.0;
                }
            } else {
                result.rotationZ = 1.5707963267948966;
                result.rotationY = Math.atan2(matrix.getValue(1, 2), matrix.getValue(2, 2));
                result.rotationX = 0.0;
            }
            return result;
        }
    }

    public static class Matrix3x3 {
        private double[] data;

        private Matrix3x3(double ... data) {
            this.data = data;
        }

        public static Matrix3x3 createRotationMatrixX(double angle) {
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            return new Matrix3x3(1.0, 0.0, 0.0, 0.0, c, -s, 0.0, s, c);
        }

        public static Matrix3x3 createRotationMatrixY(double angle) {
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            return new Matrix3x3(c, 0.0, s, 0.0, 1.0, 0.0, -s, 0.0, c);
        }

        public static Matrix3x3 createRotationMatrixZ(double angle) {
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            return new Matrix3x3(c, -s, 0.0, s, c, 0.0, 0.0, 0.0, 1.0);
        }

        public Matrix3x3 multiply(Matrix3x3 other) {
            Matrix3x3 result = new Matrix3x3(new double[9]);
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    double val = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        val += this.getValue(i, y) * other.getValue(x, i);
                    }
                    result.setValue(x, y, val);
                }
            }
            return result;
        }

        private void setValue(int x, int y, double val) {
            this.data[x + y * 3] = val;
        }

        public double getValue(int x, int y) {
            return this.data[x + y * 3];
        }

        public void debug() {
            System.out.println();
            System.out.println("[" + this.data[0] + ", " + this.data[1] + ", " + this.data[2]);
            System.out.println(this.data[3] + ", " + this.data[4] + ", " + this.data[5]);
            System.out.println(this.data[6] + ", " + this.data[7] + ", " + this.data[8] + "]");
        }
    }
}

