/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.loot;

import cofh.lib.util.WeightedRandomDrop;
import cofh.thermal.core.ThermalCore;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class GrassLootModifier
extends LootModifier {
    private List<WeightedRandomDrop> seedDrops = new ArrayList<WeightedRandomDrop>();

    public GrassLootModifier(ILootCondition[] conditionsIn, List<String> seeds) {
        super(conditionsIn);
        this.addEntry(Items.field_151014_N, 160);
        for (String seed : seeds) {
            this.addEntry(seed, 20);
        }
    }

    public void addEntry(Item seed, int weight) {
        this.seedDrops.add(new WeightedRandomDrop(seed, weight));
    }

    public void addEntry(String seed, int weight) {
        this.seedDrops.add(new WeightedRandomDrop((Item)ThermalCore.ITEMS.get(seed), weight));
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        for (ItemStack stack : generatedLoot) {
            if (stack.func_77973_b() == Items.field_151014_N) {
                WeightedRandomDrop se = (WeightedRandomDrop)WeightedRandom.func_76271_a((Random)context.func_216032_b(), this.seedDrops);
                newLoot.add(se.toItemStack(stack.func_190916_E()));
                continue;
            }
            newLoot.add(stack);
        }
        return newLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GrassLootModifier> {
        public GrassLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            ArrayList<String> seeds = new ArrayList<String>();
            JsonArray seedlist = JSONUtils.func_151214_t((JsonObject)object, (String)"seeds");
            for (JsonElement je : seedlist) {
                seeds.add(je.getAsString());
            }
            return new GrassLootModifier(ailootcondition, seeds);
        }

        public JsonObject write(GrassLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

