/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.inventory;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.inventory.ModelItem;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class InventoryModel
implements IModelGeometry<InventoryModel> {
    protected final SimpleBlockModel model;
    protected final List<ModelItem> items;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new BakedModel(baked, this.items);
    }

    public InventoryModel(SimpleBlockModel model, List<ModelItem> items) {
        this.model = model;
        this.items = items;
    }

    public static class Loader
    implements IModelLoader<InventoryModel> {
        public static final Loader INSTANCE = new Loader();

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public InventoryModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(deserializationContext, modelContents);
            List<ModelItem> items = ModelItem.listFromJson(modelContents, "items");
            return new InventoryModel(model, items);
        }
    }

    public static class BakedModel
    extends BakedModelWrapper<IBakedModel> {
        private final List<ModelItem> items;

        public BakedModel(IBakedModel originalModel, List<ModelItem> items) {
            super(originalModel);
            this.items = items;
        }

        public List<ModelItem> getItems() {
            return this.items;
        }
    }
}

