/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import slimeknights.mantle.client.model.util.ModelConfigurationWrapper;

public class ExtraTextureConfiguration
extends ModelConfigurationWrapper {
    private final Map<String, RenderMaterial> textures;

    public ExtraTextureConfiguration(IModelConfiguration base, Map<String, RenderMaterial> textures) {
        super(base);
        this.textures = textures;
    }

    public ExtraTextureConfiguration(IModelConfiguration base, String name, ResourceLocation texture) {
        super(base);
        this.textures = ImmutableMap.of((Object)name, (Object)ModelLoaderRegistry.blockMaterial((ResourceLocation)texture));
    }

    @Override
    public RenderMaterial resolveTexture(String name) {
        RenderMaterial connected = this.textures.get(name);
        if (connected != null) {
            return connected;
        }
        return super.resolveTexture(name);
    }

    @Override
    public boolean isTexturePresent(String name) {
        return this.textures.containsKey(name) || super.isTexturePresent(name);
    }
}

