/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpLootModifiers;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.TagCollectionArgument;
import slimeknights.mantle.command.TagsForCommand;
import slimeknights.mantle.command.ViewTagCommand;

public class MantleCommand {
    public static final int PERMISSION_EDIT_SPAWN = 1;
    public static final int PERMISSION_GAME_COMMANDS = 2;
    public static final int PERMISSION_PLAYER_COMMANDS = 3;
    public static final int PERMISSION_OWNER = 4;
    public static SuggestionProvider<CommandSource> VALID_TAGS;
    public static SuggestionProvider<CommandSource> REGISTRY_VALUES;

    public static void init() {
        ArgumentTypes.func_218136_a((String)"mantle:tag_collection", TagCollectionArgument.class, (IArgumentSerializer)new ArgumentSerializer(TagCollectionArgument::collection));
        VALID_TAGS = SuggestionProviders.func_197494_a((ResourceLocation)Mantle.getResource("valid_tags"), (context, builder) -> {
            TagCollectionArgument.Result result = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
            return ISuggestionProvider.func_197014_a((Iterable)result.getCollection().func_199908_a(), (SuggestionsBuilder)builder);
        });
        REGISTRY_VALUES = SuggestionProviders.func_197494_a((ResourceLocation)Mantle.getResource("registry_values"), (context, builder) -> {
            TagCollectionArgument.Result result = (TagCollectionArgument.Result)context.getArgument("type", TagCollectionArgument.Result.class);
            return ISuggestionProvider.func_197014_a((Iterable)result.getRegistry().getKeys(), (SuggestionsBuilder)builder);
        });
        MinecraftForge.EVENT_BUS.addListener(MantleCommand::registerCommand);
    }

    private static void register(LiteralArgumentBuilder<CommandSource> root, String name, Consumer<LiteralArgumentBuilder<CommandSource>> consumer) {
        LiteralArgumentBuilder subCommand = Commands.func_197057_a((String)name);
        consumer.accept((LiteralArgumentBuilder<CommandSource>)subCommand);
        root.then((ArgumentBuilder)subCommand);
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"mantle");
        MantleCommand.register((LiteralArgumentBuilder<CommandSource>)builder, "view_tag", ViewTagCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSource>)builder, "dump_tag", DumpTagCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSource>)builder, "dump_loot_modifiers", DumpLootModifiers::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSource>)builder, "dump_all_tags", DumpAllTagsCommand::register);
        MantleCommand.register((LiteralArgumentBuilder<CommandSource>)builder, "tags_for", TagsForCommand::register);
        event.getDispatcher().register(builder);
    }

    public static boolean requiresDebugInfoOrOp(CommandSource source, int reducedDebugLevel) {
        return !source.func_197023_e().func_82736_K().func_223586_b(GameRules.field_223612_o) || source.func_197034_c(reducedDebugLevel);
    }
}

