/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import slimeknights.mantle.util.TileEntityHelper;

public class BaseContainer<TILE extends TileEntity>
extends Container {
    public static double MAX_DISTANCE = 64.0;
    public static int BASE_Y_OFFSET = 84;
    @Nullable
    protected final TILE tile;
    @Nullable
    protected final PlayerInventory inv;
    protected int playerInventoryStart = -1;

    protected BaseContainer(ContainerType<?> type, int id, @Nullable PlayerInventory inv, @Nullable TILE tile) {
        super(type, id);
        this.inv = inv;
        this.tile = tile;
    }

    @Nullable
    public TILE getTile() {
        return this.tile;
    }

    public void syncOnOpen(ServerPlayerEntity playerOpened) {
        ServerWorld server = playerOpened.func_71121_q();
        for (PlayerEntity player : server.func_217369_A()) {
            if (player == playerOpened || !(player.field_71070_bA instanceof BaseContainer) || !this.sameGui((BaseContainer)player.field_71070_bA)) continue;
            this.syncWithOtherContainer((BaseContainer)player.field_71070_bA, playerOpened);
            return;
        }
        this.syncNewContainer(playerOpened);
    }

    protected void syncWithOtherContainer(BaseContainer otherContainer, ServerPlayerEntity player) {
    }

    protected void syncNewContainer(ServerPlayerEntity player) {
    }

    public boolean sameGui(BaseContainer otherContainer) {
        if (this.tile == null) {
            return false;
        }
        return this.tile == otherContainer.tile;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.tile == null) {
            return true;
        }
        if (!this.tile.func_145837_r()) {
            World world = this.tile.func_145831_w();
            if (world == null) {
                return false;
            }
            return world.func_195588_v(this.tile.func_174877_v());
        }
        return false;
    }

    public NonNullList<ItemStack> func_75138_a() {
        return super.func_75138_a();
    }

    protected void addInventorySlots() {
        if (this.inv != null) {
            this.addInventorySlots(this.inv);
        }
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected int getInventoryYOffset() {
        return BASE_Y_OFFSET;
    }

    protected void addInventorySlots(PlayerInventory inv) {
        int slotY;
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        int start = this.field_75151_b.size();
        for (slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new Slot((IInventory)inv, slotX + slotY * 9 + 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (slotY = 0; slotY < 9; ++slotY) {
            this.func_75146_a(new Slot((IInventory)inv, slotY, xOffset + slotY * 18, yOffset));
        }
        this.playerInventoryStart = start;
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (this.playerInventoryStart >= 0) {
            throw new IllegalStateException("BaseContainer: Player inventory has to be last slots. Add all slots before adding the player inventory.");
        }
        return super.func_75146_a(slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int end = this.field_75151_b.size();
            if (index < this.playerInventoryStart ? !this.func_75135_a(itemstack1, this.playerInventoryStart, end, true) : !this.func_75135_a(itemstack1, 0, this.playerInventoryStart, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.func_190926_b() && stack.func_190916_E() > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == stack.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1) && this.func_94530_a(stack, slot)) {
                    int limit;
                    int l = itemstack1.func_190916_E() + stack.func_190916_E();
                    if (l <= (limit = Math.min(stack.func_77976_d(), slot.func_178170_b(stack)))) {
                        stack.func_190920_e(0);
                        itemstack1.func_190920_e(l);
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.func_190916_E() < limit) {
                        stack.func_190918_g(limit - itemstack1.func_190916_E());
                        itemstack1.func_190920_e(limit);
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1.func_190926_b() && slot.func_75214_a(stack) && this.func_94530_a(stack, slot)) {
                int limit = slot.func_178170_b(stack);
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.func_190916_E() > limit) {
                    stack2.func_190920_e(limit);
                    stack.func_190918_g(limit);
                } else {
                    stack.func_190920_e(0);
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                flag1 = true;
                if (stack.func_190926_b()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }

    @Nullable
    public static <TILE extends TileEntity> TILE getTileEntityFromBuf(@Nullable PacketBuffer buf, Class<TILE> type) {
        if (buf == null) {
            return null;
        }
        return (TILE)((TileEntity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> TileEntityHelper.getTile(type, (IBlockReader)Minecraft.func_71410_x().field_71441_e, buf.func_179259_c()).orElse(null)));
    }
}

