/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.CompareBlockFunctions;
import com.natamus.collective.functions.ToolFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import com.natamus.treeharvester.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TreeEvent {
    private static HashMap<World, CopyOnWriteArrayList<List<BlockPos>>> processleaves = new HashMap();

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        processleaves.put(world, new CopyOnWriteArrayList());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (processleaves.get(world).size() == 0) {
            return;
        }
        block0: for (List<BlockPos> leaves : processleaves.get(world)) {
            BlockPos lasttr = null;
            int size = leaves.size();
            if (size > 0) {
                BlockPos tr = leaves.get(0);
                BlockFunctions.dropBlock((World)world, (BlockPos)tr);
                leaves.remove(0);
                if (leaves.size() > 0) {
                    tr = leaves.get(0);
                    BlockFunctions.dropBlock((World)world, (BlockPos)tr);
                    leaves.remove(0);
                }
                lasttr = tr.func_185334_h();
            }
            if (leaves.size() != 0) continue;
            processleaves.get(world).remove(leaves);
            if (lasttr == null || !((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue() || Util.lowerlogs.size() <= 0) continue;
            BlockPos lowerlasttrpos = new BlockPos(lasttr.func_177958_n(), 1, lasttr.func_177952_p());
            for (Pair<BlockPos, CopyOnWriteArrayList<BlockPos>> pair : Util.lowerlogs) {
                BlockPos breakpos = (BlockPos)pair.getFirst();
                if (!BlockPosFunctions.withinDistance((BlockPos)lowerlasttrpos, (BlockPos)new BlockPos(breakpos.func_177958_n(), 1, breakpos.func_177952_p()), (int)5).booleanValue()) continue;
                Util.replaceSapling(world, breakpos, (CopyOnWriteArrayList)pair.getSecond(), 1);
                Util.lowerlogs.remove(pair);
                continue block0;
            }
        }
    }

    @SubscribeEvent
    public void onTreeHarvest(BlockEvent.BreakEvent e) {
        int logcount;
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BlockPos bpos = e.getPos();
        Block block = world.func_180495_p(bpos).func_177230_c();
        if (!CompareBlockFunctions.isTreeLog((Block)block)) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if ((Boolean)ConfigHandler.GENERAL.treeHarvestWithoutSneak.get() != false ? player.func_225608_bj_() : !player.func_225608_bj_()) {
            return;
        }
        ItemStack hand = player.func_184586_b(Hand.MAIN_HAND);
        if (((Boolean)ConfigHandler.GENERAL.mustHoldAxeForTreeHarvest.get()).booleanValue() && !ToolFunctions.isAxe((ItemStack)hand).booleanValue()) {
            return;
        }
        if (hand == null) {
            return;
        }
        if (((Boolean)ConfigHandler.GENERAL.automaticallyFindBottomBlock.get()).booleanValue()) {
            BlockPos temppos = bpos.func_185334_h();
            while (world.func_180495_p(temppos.func_177977_b()).func_177230_c().equals(block)) {
                temppos = temppos.func_177977_b().func_185334_h();
            }
            bpos = temppos.func_185334_h();
        }
        if ((logcount = Util.isTreeAndReturnLogAmount(world, bpos)) < 0) {
            return;
        }
        Item handitem = hand.func_77973_b();
        int durabilitylosecount = (int)Math.ceil(1.0 / (Double)ConfigHandler.GENERAL.loseDurabilityModifier.get());
        int durabilitystartcount = -1;
        List<BlockPos> logstobreak = Util.getAllLogsToBreak(world, bpos, logcount, block);
        for (BlockPos logpos : logstobreak) {
            BlockState logstate = world.func_180495_p(logpos);
            Block log = logstate.func_177230_c();
            if (!log.canHarvestBlock(logstate, (IBlockReader)world, logpos, player)) continue;
            world.func_175655_b(logpos, false);
            log.func_180657_a(world, player, logpos, logstate, null, hand);
            if (player.func_184812_l_()) continue;
            if (((Boolean)ConfigHandler.GENERAL.loseDurabilityPerHarvestedLog.get()).booleanValue()) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    handitem.func_179218_a(hand, world, logstate, logpos, (LivingEntity)player);
                } else if (--durabilitylosecount == 0) {
                    handitem.func_179218_a(hand, world, logstate, logpos, (LivingEntity)player);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!((Boolean)ConfigHandler.GENERAL.increaseExhaustionPerHarvestedLog.get()).booleanValue()) continue;
            player.func_71020_j(0.025f * ((Double)ConfigHandler.GENERAL.increaseExhaustionModifier.get()).floatValue());
        }
        if (logstobreak.size() == 0) {
            return;
        }
        e.setCanceled(true);
        if (((Boolean)ConfigHandler.GENERAL.enableFastLeafDecay.get()).booleanValue() && !((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) {
            ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
            ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
            for (BlockPos next : BlockPos.func_191531_b((int)(bpos.func_177958_n() - 8), (int)bpos.func_177956_o(), (int)(bpos.func_177952_p() - 8), (int)(bpos.func_177958_n() + 8), (int)Util.highestleaf.get(bpos), (int)(bpos.func_177952_p() + 8))) {
                if (!CompareBlockFunctions.isTreeLog((Block)world.func_180495_p(next).func_177230_c())) continue;
                logs.add(next.func_185334_h());
            }
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(logcount);
            int h = (Integer)hv.getFirst();
            for (BlockPos next : BlockPos.func_191531_b((int)(bpos.func_177958_n() - h), (int)bpos.func_177956_o(), (int)(bpos.func_177952_p() - h), (int)(bpos.func_177958_n() + h), (int)Util.highestleaf.get(bpos), (int)(bpos.func_177952_p() + h))) {
                if (!CompareBlockFunctions.isTreeLeaf((Block)world.func_180495_p(next).func_177230_c(), (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get()))) continue;
                boolean logclose = false;
                for (BlockPos log : logs) {
                    double distance = log.func_177951_i((Vector3i)next);
                    if (!(distance < 7.0)) continue;
                    logclose = true;
                    break;
                }
                if (logclose) continue;
                leaves.add(next.func_185334_h());
            }
            Collections.shuffle(leaves);
            processleaves.get(world).add(leaves);
            Util.highestleaf.remove(bpos);
        }
    }
}

