/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonBigTunnelPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

@MethodsReturnNonnullByDefault
public class SpiderDungeonStructure
extends Structure<NoFeatureConfig> {
    public static List<String> whitelistedDimensions = Lists.newArrayList((Object[])new String[]{"minecraft:overworld"});
    public static List<String> blacklistedBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:ocean", "minecraft:frozen_ocean", "minecraft:deep_ocean", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:cold_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_frozen_ocean", "minecraft:beach", "minecraft:snowy_beach", "minecraft:river", "minecraft:frozen_river"});
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 15), (Object)new MobSpawnInfo.Spawners(EntityType.field_200794_h, 50, 4, 8));

    public SpiderDungeonStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public boolean getDefaultRestrictsSpawnsToInside() {
        return true;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @ParametersAreNonnullByDefault
        public void func_230364_a_(DynamicRegistries registryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int startX = chunkX << 4;
            int startZ = chunkZ << 4;
            SpiderDungeonBigTunnelPiece startPiece = new SpiderDungeonBigTunnelPiece(startX, startZ, (Random)this.field_214631_d);
            this.field_75075_a.add(startPiece);
            startPiece.func_74861_a(startPiece, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            BetterDungeons.LOGGER.debug("Spider Dungeon at {} {} {}", (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a, (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b, (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

