/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ICatchableMob {
    default public boolean canBeCaughtWithItem(Item item2) {
        switch (item2.getRegistryName().toString()) {
            case "supplementaries:jar": {
                return this.canBeCaughtWithJar();
            }
            case "supplementaries:tinted_jar": {
                return this.canBeCaughtWithTintedJar();
            }
            case "supplementaries:cage": {
                return this.canBeCaughtWithCage();
            }
        }
        return false;
    }

    public boolean canBeCaughtWithJar();

    public boolean canBeCaughtWithTintedJar();

    public boolean canBeCaughtWithCage();

    default public float getHitBoxWidthIncrement() {
        return 0.0f;
    }

    default public float getHitBoxHeightIncrement() {
        return 0.0f;
    }

    default public int getLightLevel() {
        return 0;
    }

    default public void tickInsideContainer(World world, BlockPos pos, float entityScale, CompoundNBT entityData) {
    }

    default public ActionResultType onPlayerInteract(World world, BlockPos pos, PlayerEntity player, Hand hand, CompoundNBT entityData) {
        return ActionResultType.PASS;
    }

    default public boolean isFlyingMob(boolean waterlogged) {
        return this.isFlyingMob();
    }

    default public boolean isFlyingMob() {
        Entity entity2 = this.getEntity();
        return entity2.func_189652_ae() || entity2 instanceof IFlyingAnimal || entity2.func_145773_az() || entity2 instanceof WaterMobEntity;
    }

    public Entity getEntity();

    default public boolean shouldHaveWater() {
        return false;
    }

    default public void onContainerWaterlogged(boolean waterlogged) {
    }

    default public void setContainerDimensions(float width, float height) {
    }
}

