/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LockBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public LockBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return ActionResultType.PASS;
        }
        BlockPos p = this.hasTileEntity(state) ? pos : pos.func_177977_b();
        TileEntity te = worldIn.func_175625_s(p);
        if (te instanceof KeyLockableTile && ((KeyLockableTile)te).handleAction(player, handIn, "lock_block")) {
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 7);
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 20);
            }
            worldIn.func_217378_a(player, 1037, pos, 0);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    protected void playSound(@Nullable PlayerEntity player, World worldIn, BlockPos pos, boolean isOpened) {
        if (isOpened) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_217378_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_217378_a(player, j, pos, 0);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 7);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KeyLockableTile();
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.key.lockable").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
    }
}

