/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.renderers.color.HSLColor;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.enchantedbooks.EnchantedBookRedesignRenderer;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.item.BookItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class BookPileBlockTile
extends ItemDisplayTile {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final List<VisualBook> books = new ArrayList<VisualBook>();
    private static final BookColor[] VALID_RANDOM_COLORS = new BookColor[]{BookColor.BROWN, BookColor.ORANGE, BookColor.YELLOW, BookColor.RED, BookColor.DARK_GREEN, BookColor.LIME, BookColor.TEAL, BookColor.BLUE, BookColor.PURPLE};

    public BookPileBlockTile() {
        this(false);
    }

    public BookPileBlockTile(boolean horizontal) {
        super((TileEntityType)ModRegistry.BOOK_PILE_TILE.get(), 4);
        this.horizontal = horizontal;
    }

    public void updateTileOnInventoryChanged() {
        int b = (int)this.func_190576_q().stream().filter(i -> !i.func_190926_b()).count();
        if (b != (Integer)this.func_195044_w().func_177229_b((Property)BookPileBlock.BOOKS)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(b)), 2);
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            Item item2 = this.func_70301_a(i2).func_77973_b();
            if (BookPileBlock.isQuarkTome(item2)) {
                this.enchantPower += ServerConfigs.cached.BOOK_POWER / 4.0f * 2.0f;
                continue;
            }
            if (BookPileBlock.isEnchantedBook(item2)) {
                this.enchantPower += ServerConfigs.cached.ENCHANTED_BOOK_POWER / 4.0f;
                continue;
            }
            if (!BookPileBlock.isNormalBook(item2)) continue;
            this.enchantPower += ServerConfigs.cached.BOOK_POWER / 4.0f;
        }
    }

    public void updateClientVisualsOnLoad() {
        ItemStack stack;
        this.books.clear();
        ArrayList<BookColor> colors = new ArrayList<BookColor>(Arrays.asList(VALID_RANDOM_COLORS));
        for (int i = 0; i < 4 && !(stack = this.func_70301_a(i)).func_190926_b(); ++i) {
            BookColor last = i == 0 ? null : this.books.get(i - 1).color;
            this.books.add(i, new VisualBook(stack, this.field_174879_c, i, colors, last));
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected ITextComponent func_213907_g() {
        return new StringTextComponent("block.supplementaries.book_pile");
    }

    public static enum BookColor {
        BROWN(DyeColor.BROWN, 1),
        WHITE(DyeColor.WHITE, 1),
        BLACK(DyeColor.BLACK, 1),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY),
        GRAY(DyeColor.GRAY),
        ORANGE(DyeColor.ORANGE),
        YELLOW(DyeColor.YELLOW),
        LIME(DyeColor.LIME),
        DARK_GREEN("green", 3129655),
        TEAL("cyan", 1502399),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE),
        BLUE(DyeColor.BLUE),
        PURPLE(DyeColor.PURPLE),
        MAGENTA(DyeColor.MAGENTA),
        PINK(DyeColor.PINK),
        RED(DyeColor.RED);

        private final String name;
        private final float hue;
        private final float angle;

        private BookColor(String s, int rgb, int angle) {
            this.name = s;
            float[] col = HSLColor.rgbToHsl(rgb);
            this.hue = col[0];
            this.angle = angle < 0 ? this.getAllowedHueShift(col) : (float)Math.max(1, angle);
        }

        private BookColor(DyeColor color, int angle) {
            this(color.func_176762_d(), color.getColorValue(), angle);
        }

        private BookColor(String name, int color) {
            this(name, color, -1);
        }

        private BookColor(DyeColor color) {
            this(color.func_176762_d(), color.getColorValue(), -1);
        }

        public static BookColor byName(String name) {
            for (BookColor c : BookColor.values()) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return BROWN;
        }

        public boolean looksGoodNextTo(BookColor other) {
            float diff = Math.abs(MathHelper.func_203302_c((float)(this.hue * 360.0f), (float)(other.hue * 360.0f)) / 360.0f);
            return diff < (other.angle + this.angle) / 2.0f;
        }

        private float getAllowedHueShift(float[] col) {
            float l = col[2];
            float s = HSLColor.oneToOneSaturation(col[1], l);
            float minAngle = 0.25f;
            float addAngle = 0.18055555f;
            float distLightSq = 2.0f;
            float distDarkSq = s * s + l * l;
            float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
            return minAngle + (1.0f - distSq) * addAngle;
        }

        public static BookColor rand(Random r) {
            return BookColor.values()[r.nextInt(BookColor.values().length)];
        }

        public String getName() {
            return this.name;
        }
    }

    public static class VisualBook {
        private final float angle;
        @Nullable
        private final BookColor color;
        private final RenderMaterial material;
        private final ItemStack stack;
        private final boolean isEnchanted;

        public VisualBook(ItemStack stack, BlockPos pos, int index, List<BookColor> colors, @Nullable BookColor lastColor) {
            this.stack = stack;
            Random rand = new Random(pos.func_218275_a());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            Item item2 = stack.func_77973_b();
            this.angle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item2 instanceof BookItem) {
                if (lastColor == null) {
                    this.color = colors.get(rand.nextInt(colors.size()));
                } else {
                    List c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).collect(Collectors.toList());
                    this.color = (BookColor)((Object)c.get(rand.nextInt(c.size())));
                }
                colors.remove((Object)this.color);
                this.material = Materials.BOOK_MATERIALS.get((Object)this.color);
                this.isEnchanted = false;
            } else if (item2.getRegistryName().func_110624_b().equals("inspirations")) {
                String colName = item2.getRegistryName().func_110623_a().replace("_book", "");
                this.color = BookColor.byName(colName);
                this.material = Materials.BOOK_MATERIALS.get((Object)this.color);
                this.isEnchanted = false;
            } else if (BookPileBlock.isWrittenBook(item2)) {
                this.color = null;
                this.material = Materials.BOOK_WRITTEN_MATERIAL;
                this.isEnchanted = false;
            } else {
                this.color = null;
                this.material = BookPileBlock.isQuarkTome(item2) ? Materials.BOOK_TOME_MATERIAL : Materials.BOOK_ENCHANTED_MATERIAL;
                this.isEnchanted = true;
            }
        }

        public IVertexBuilder getBuilder(IRenderTypeBuffer buffer) {
            if (this.isEnchanted && ClientConfigs.cached.BOOK_GLINT) {
                IVertexBuilder foilBuilder = null;
                if (CompatHandler.enchantedbookredesign) {
                    foilBuilder = EnchantedBookRedesignRenderer.getColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = buffer.getBuffer(RenderType.func_228655_k_());
                }
                return VertexBuilderUtils.func_227915_a_((IVertexBuilder)foilBuilder, (IVertexBuilder)this.material.func_229311_a_(buffer, RenderType::func_228634_a_));
            }
            return this.material.func_229311_a_(buffer, RenderType::func_228634_a_);
        }

        public float getAngle() {
            return this.angle;
        }

        public boolean isEnchanted() {
            return this.isEnchanted;
        }
    }
}

