/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.List;
import net.mehvahdjukaar.supplementaries.block.blocks.CrackedBellBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class CrackedBellBlockTile
extends TileEntity
implements ITickableTileEntity {
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<LivingEntity> nearbyEntities;
    private boolean resonating;
    private int resonationTicks;

    public CrackedBellBlockTile() {
        super((TileEntityType)ModRegistry.CRACKED_BELL_TILE.get());
    }

    public boolean isOnFloor() {
        return this.func_195044_w().func_177229_b(CrackedBellBlock.ATTACHMENT) == BellAttachment.FLOOR;
    }

    public boolean func_145842_c(int index, int data) {
        if (index == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.func_82600_a((int)data);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.func_145842_c(index, data);
    }

    public void func_73660_a() {
        if (this.shaking) {
            ++this.ticks;
        }
        if (this.ticks >= 50) {
            this.shaking = false;
            this.ticks = 0;
        }
        if (this.ticks >= 5 && this.resonationTicks == 0 && this.areRaidersNearby()) {
            this.resonating = true;
            this.playResonateSound();
        }
        if (this.resonating) {
            if (this.resonationTicks < 40) {
                ++this.resonationTicks;
            } else {
                this.makeRaidersGlow(this.field_145850_b);
                this.showBellParticles(this.field_145850_b);
                this.resonating = false;
            }
        }
    }

    private void playResonateSound() {
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_219604_Z, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void onHit(Direction direction) {
        BlockPos blockpos = this.func_174877_v();
        this.clickDirection = direction;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.field_145850_b.func_175641_c(blockpos, this.func_195044_w().func_177230_c(), 1, direction.func_176745_a());
    }

    private void updateEntities() {
        BlockPos blockpos = this.func_174877_v();
        if (this.field_145850_b.func_82737_E() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.field_145850_b.func_82737_E();
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos).func_186662_g(48.0);
            this.nearbyEntities = this.field_145850_b.func_217357_a(LivingEntity.class, axisalignedbb);
        }
        if (!this.field_145850_b.field_72995_K) {
            for (LivingEntity livingentity : this.nearbyEntities) {
                if (!livingentity.func_70089_S() || livingentity.field_70128_L || !blockpos.func_218137_a((IPosition)livingentity.func_213303_ch(), 32.0)) continue;
                livingentity.func_213375_cj().func_218205_a(MemoryModuleType.field_220962_w, (Object)this.field_145850_b.func_82737_E());
            }
        }
    }

    private boolean areRaidersNearby() {
        BlockPos blockpos = this.func_174877_v();
        for (LivingEntity livingentity : this.nearbyEntities) {
            if (!livingentity.func_70089_S() || livingentity.field_70128_L || !blockpos.func_218137_a((IPosition)livingentity.func_213303_ch(), 32.0) || !livingentity.func_200600_R().func_220341_a((ITag)EntityTypeTags.field_219765_b)) continue;
            return true;
        }
        return false;
    }

    private void makeRaidersGlow(World p_222828_1_) {
        if (!p_222828_1_.field_72995_K) {
            this.nearbyEntities.stream().filter(this::isRaiderWithinRange).forEach(this::glow);
        }
    }

    private void showBellParticles(World p_222826_1_) {
        if (p_222826_1_.field_72995_K) {
            BlockPos blockpos = this.func_174877_v();
            MutableInt mutableint = new MutableInt(16700985);
            int i = (int)this.nearbyEntities.stream().filter(e -> blockpos.func_218137_a((IPosition)e.func_213303_ch(), 48.0)).count();
            this.nearbyEntities.stream().filter(this::isRaiderWithinRange).forEach(e -> {
                float f = 1.0f;
                float f1 = MathHelper.func_76133_a((double)((e.func_226277_ct_() - (double)blockpos.func_177958_n()) * (e.func_226277_ct_() - (double)blockpos.func_177958_n()) + (e.func_226281_cx_() - (double)blockpos.func_177952_p()) * (e.func_226281_cx_() - (double)blockpos.func_177952_p())));
                double d0 = (double)((float)blockpos.func_177958_n() + 0.5f) + (double)(1.0f / f1) * (e.func_226277_ct_() - (double)blockpos.func_177958_n());
                double d1 = (double)((float)blockpos.func_177952_p() + 0.5f) + (double)(1.0f / f1) * (e.func_226281_cx_() - (double)blockpos.func_177952_p());
                int j = MathHelper.func_76125_a((int)((i - 21) / -2), (int)3, (int)15);
                for (int k = 0; k < j; ++k) {
                    int l = mutableint.addAndGet(5);
                    double d2 = (double)ColorHelper.PackedColor.func_233007_b_((int)l) / 255.0;
                    double d3 = (double)ColorHelper.PackedColor.func_233008_c_((int)l) / 255.0;
                    double d4 = (double)ColorHelper.PackedColor.func_233009_d_((int)l) / 255.0;
                    p_222826_1_.func_195594_a((IParticleData)ParticleTypes.field_197625_r, d0, (double)((float)blockpos.func_177956_o() + 0.5f), d1, d2, d3, d4);
                }
            });
        }
    }

    private boolean isRaiderWithinRange(LivingEntity entity2) {
        return entity2.func_70089_S() && !entity2.field_70128_L && this.func_174877_v().func_218137_a((IPosition)entity2.func_213303_ch(), 48.0) && entity2.func_200600_R().func_220341_a((ITag)EntityTypeTags.field_219765_b);
    }

    private void glow(LivingEntity entity2) {
        entity2.func_195064_c(new EffectInstance(Effects.field_188423_x, 60));
    }
}

