/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.inventories.PresentContainer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PresentBlockTile
extends ItemDisplayTile {
    private int numPlayersUsing;
    private String recipient = "";
    private String sender = "";
    private boolean packed = false;

    public PresentBlockTile() {
        super((TileEntityType)ModRegistry.PRESENT_TILE.get());
    }

    public boolean isUnused() {
        return this.numPlayersUsing <= 0;
    }

    public static boolean isPacked(ItemStack stack) {
        CompoundNBT nbt;
        CompoundNBT com = stack.func_77978_p();
        if (com != null && (nbt = com.func_74775_l("BlockEntityTag")) != null) {
            return nbt.func_74767_n("Packed");
        }
        return false;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void unpack() {
        this.recipient = "";
        this.sender = "";
        this.packed = false;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PresentBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void pack(String recipient, String sender, boolean doPack) {
        this.recipient = recipient;
        this.sender = sender;
        this.packed = doPack;
        if (doPack && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PresentBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void pack(String recipient, String sender) {
        this.pack(recipient, sender, true);
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.present");
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("Recipient")) {
            this.recipient = tag.func_74779_i("Recipient");
        }
        if (tag.func_74764_b("Sender")) {
            this.sender = tag.func_74779_i("Sender");
        }
        this.packed = tag.func_74767_n("Packed");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.recipient.isEmpty()) {
            tag.func_74778_a("Recipient", this.recipient);
        }
        if (!this.sender.isEmpty()) {
            tag.func_74778_a("Sender", this.sender);
        }
        tag.func_74757_a("Packed", this.packed);
        return tag;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new PresentContainer(id, player, (IInventory)this, this.field_174879_c);
    }

    public static boolean isAcceptableItem(ItemStack stack) {
        Item i = stack.func_77973_b();
        return CommonUtil.isAllowedInShulker(stack) && (!(i instanceof BlockItem) || !(((BlockItem)i).func_179223_d() instanceof PresentBlock));
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return PresentBlockTile.isAcceptableItem(stack);
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }
}

