/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.mehvahdjukaar.supplementaries.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

public class BlackboardTextureManager {
    public static final ResourceLocation BLACKBOARD_ATLAS = new ResourceLocation("supplementaries", "textures/atlas/blackboards.png");
    public static BlackboardTextureManager INSTANCE = null;
    private final TextureManager textureManager;
    private long lastID = 0L;
    private final LoadingCache<BlackboardKey, TextureInstance> blackboardTextures = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<BlackboardKey, TextureInstance>(){

        public TextureInstance load(BlackboardKey key) {
            return null;
        }
    });

    public long bindNextID() {
        return ++this.lastID;
    }

    public static void init(TextureManager textureManager) {
        INSTANCE = new BlackboardTextureManager(textureManager);
    }

    public BlackboardTextureManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public RenderType getRenderType(BlackboardBlockTile tile) {
        return this.getTextureInstance(tile).renderType;
    }

    public RenderType getRenderType(long[] packed) {
        return this.getTextureInstance(packed).renderType;
    }

    public ResourceLocation getResourceLocation(long[] packed) {
        return this.getTextureInstance(packed).resourceLocation;
    }

    public ResourceLocation getResourceLocation(BlackboardBlockTile tile) {
        return this.getTextureInstance(tile).resourceLocation;
    }

    public ResourceLocation getResourceLocation(BlackboardKey key) {
        return this.getTextureInstance(key).resourceLocation;
    }

    public RenderType getRenderType(BlackboardKey key) {
        return this.getTextureInstance(key).renderType;
    }

    public TextureInstance getTextureInstance(BlackboardKey key) {
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(BlackboardBlockTile.unpackPixels(key.values), this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public TextureInstance getTextureInstance(long[] packed) {
        BlackboardKey key = new BlackboardKey(packed);
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(BlackboardBlockTile.unpackPixels(packed), this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    private TextureInstance getTextureInstance(BlackboardBlockTile tile) {
        BlackboardKey key = this.getOrCreateTextureKey(tile);
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(tile.pixels, this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    private BlackboardKey getOrCreateTextureKey(BlackboardBlockTile tile) {
        if (tile.textureKey == null) {
            tile.textureKey = new BlackboardKey(tile.pixels);
        }
        return tile.textureKey;
    }

    public BlackboardKey getUpdatedKey(BlackboardBlockTile tile) {
        BlackboardKey key = new BlackboardKey(tile.pixels);
        if (this.blackboardTextures.getIfPresent((Object)key) == null) {
            this.blackboardTextures.put((Object)key, (Object)new TextureInstance(tile.pixels, this.bindNextID()));
        }
        return key;
    }

    private static int getColoredPixel(byte i, int x, int y) {
        int offset = i > 0 ? 16 : 0;
        int tint = BlackboardBlock.colorFromByte(i);
        AtlasTexture textureMap = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = textureMap.func_195424_a(Textures.BLACKBOARD_TEXTURE);
        return BlackboardTextureManager.getTintedColor(sprite, x, y, offset, tint);
    }

    private static int getTintedColor(TextureAtlasSprite sprite, int x, int y, int offset, int tint) {
        if (sprite == null || sprite.func_110970_k() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int pixel = sprite.getPixelRGBA(0, x + offset, y);
        int totalB = pixel >> 16 & 0xFF;
        int totalG = pixel >> 8 & 0xFF;
        int totalR = pixel & 0xFF;
        return NativeImage.func_227787_a_((int)255, (int)(totalB * tintB / 255), (int)(totalG * tintG / 255), (int)(totalR * tintR / 255));
    }

    private class TextureInstance
    implements AutoCloseable {
        private final DynamicTexture texture = new DynamicTexture(16, 16, false);
        private final RenderType renderType;
        private final ResourceLocation resourceLocation;

        private TextureInstance(byte[][] pixels, long id) {
            this.updateTexture(pixels);
            this.resourceLocation = BlackboardTextureManager.this.textureManager.func_110578_a("blackboard/" + Long.toHexString(id), this.texture);
            this.renderType = RenderType.func_228634_a_((ResourceLocation)this.resourceLocation);
        }

        private void updateTexture(byte[][] pixels) {
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.func_195414_e().func_195700_a(x, y, BlackboardTextureManager.getColoredPixel(pixels[x][y], x, y));
                }
            }
            this.texture.func_110564_a();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }

    public static class BlackboardKey {
        private final long[] values;

        public BlackboardKey(long[] packed) {
            this.values = packed;
        }

        public BlackboardKey(byte[][] pixels) {
            this.values = BlackboardBlockTile.packPixels(pixels);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            BlackboardKey key = (BlackboardKey)another;
            return Arrays.equals(this.values, key.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

