/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;

public class FaucetBlockTileRenderer
extends TileEntityRenderer<FaucetBlockTile> {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public FaucetBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(FaucetBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int light, int ov) {
        if (tile.hasWater() && tile.isOpen() && !tile.isConnectedBelow() && !CommonUtil.FESTIVITY.isEarthDay()) {
            ResourceLocation texture = tile.fluidHolder.getFluid().getFlowingTexture();
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
            IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_239269_g_());
            int color = tile.fluidHolder.getFlowingTint((IWorldReader)tile.func_145831_w(), tile.func_174877_v());
            int luminosity = tile.fluidHolder.getFluid().getLuminosity();
            if (luminosity != 0) {
                light = light & 0xF00000 | luminosity << 4;
            }
            float opacity = 1.3f;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.25, 0.5);
            matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
            float h = 0.03125f;
            for (int i = 0; i < 16; ++i) {
                opacity = Math.min(1.0f, opacity - 0.0082f * (float)i);
                RendererUtil.addCube(builder, matrixStackIn, 0.0f, (float)i * h, 0.125f, h, sprite, light, color, opacity, false, false, true, false, true);
                matrixStackIn.func_227861_a_(0.0, (double)(-h), 0.0);
            }
            matrixStackIn.func_227865_b_();
        }
    }
}

