/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.HangingSignBlockTile;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.LOD;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.RequestMapDataFromServerPacket;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class HangingSignBlockTileRenderer
extends TileEntityRenderer<HangingSignBlockTile> {
    protected final BlockRendererDispatcher blockRenderer;
    protected final ItemRenderer itemRenderer;
    protected final MapItemRenderer mapRenderer;

    public HangingSignBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Minecraft minecraft = Minecraft.func_71410_x();
        this.blockRenderer = minecraft.func_175602_ab();
        this.itemRenderer = minecraft.func_175599_af();
        this.mapRenderer = minecraft.field_71460_t.func_147701_i();
    }

    public void render(HangingSignBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        if (((Boolean)tile.func_195044_w().func_177229_b((Property)HangingSignBlock.HANGING)).booleanValue()) {
            matrixStackIn.func_227861_a_(0.0, 0.125, 0.0);
        }
        matrixStackIn.func_227861_a_(0.5, 0.875, 0.5);
        matrixStackIn.func_227863_a_(Const.rot(tile.getDirection().func_176734_d()));
        matrixStackIn.func_227863_a_(Const.XN90);
        LOD lod = new LOD(this.field_228858_b_, tile.func_174877_v());
        if (lod.isNear()) {
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)tile.prevAngle, (float)tile.angle)));
        }
        matrixStackIn.func_227861_a_(-0.5, -0.875, -0.5);
        BlockState state = (BlockState)tile.func_195044_w().func_177230_c().func_176223_P().func_206870_a((Property)HangingSignBlock.TILE, (Comparable)Boolean.valueOf(true));
        this.blockRenderer.renderBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        if (lod.isMedium()) {
            matrixStackIn.func_227861_a_(0.5, 0.3125, 0.5);
            matrixStackIn.func_227863_a_(Const.YN90);
            if (!tile.isEmpty()) {
                ItemStack stack = tile.getStackInSlot(0);
                Item item2 = stack.func_77973_b();
                if (item2 instanceof AbstractMapItem) {
                    MapData mapdata = FilledMapItem.func_195950_a((ItemStack)stack, (World)tile.func_145831_w());
                    if (mapdata != null) {
                        for (int v = 0; v < 2; ++v) {
                            matrixStackIn.func_227860_a_();
                            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0675);
                            matrixStackIn.func_227862_a_(0.0068359375f, -0.0068359375f, -0.0068359375f);
                            matrixStackIn.func_227861_a_(-64.0, -64.0, 0.0);
                            this.mapRenderer.func_228086_a_(matrixStackIn, bufferIn, mapdata, true, combinedLightIn);
                            matrixStackIn.func_227865_b_();
                            matrixStackIn.func_227863_a_(Const.Y180);
                        }
                    } else {
                        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                        NetworkHandler.INSTANCE.sendToServer((Object)new RequestMapDataFromServerPacket(tile.func_174877_v(), player.func_110124_au()));
                    }
                } else if (item2 instanceof BannerPatternItem) {
                    RenderMaterial rendermaterial = Materials.FLAG_MATERIALS.get(((BannerPatternItem)item2).func_219980_b());
                    IVertexBuilder builder = rendermaterial.func_229311_a_(bufferIn, RenderType::func_228650_h_);
                    int i = tile.textHolder.textColor.getColorValue();
                    float b = (float)NativeImage.func_227791_b_((int)i) / 255.0f;
                    float g = (float)NativeImage.func_227793_c_((int)i) / 255.0f;
                    float r = (float)NativeImage.func_227795_d_((int)i) / 255.0f;
                    int lu = combinedLightIn & 0xFFFF;
                    int lv = combinedLightIn >> 16 & 0xFFFF;
                    for (int v = 0; v < 2; ++v) {
                        RendererUtil.addQuadSide(builder, matrixStackIn, -0.4375f, -0.4375f, 0.0725f, 0.4375f, 0.4375f, 0.0725f, 0.15625f, 0.0625f, 0.59375f, 0.9375f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, rendermaterial.func_229314_c_());
                        matrixStackIn.func_227863_a_(Const.Y180);
                    }
                } else {
                    IBakedModel ibakedmodel = this.itemRenderer.func_184393_a(stack, tile.func_145831_w(), null);
                    for (int v = 0; v < 2; ++v) {
                        matrixStackIn.func_227860_a_();
                        matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
                        matrixStackIn.func_227861_a_(0.0, 0.0, -0.1);
                        this.itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
                        matrixStackIn.func_227865_b_();
                        matrixStackIn.func_227863_a_(Const.Y180);
                        matrixStackIn.func_227862_a_(0.9995f, 0.9995f, 0.9995f);
                    }
                }
            } else if (lod.isNearMed()) {
                FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
                int i = tile.textHolder.textColor.func_218388_g();
                int j = (int)((double)NativeImage.func_227791_b_((int)i) * 0.4);
                int k = (int)((double)NativeImage.func_227793_c_((int)i) * 0.4);
                int l = (int)((double)NativeImage.func_227795_d_((int)i) * 0.4);
                int i1 = NativeImage.func_227787_a_((int)0, (int)l, (int)k, (int)j);
                matrixStackIn.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
                for (int k1 = 0; k1 < 7; ++k1) {
                    IReorderingProcessor ireorderingprocessor = tile.textHolder.getRenderText(k1, ss -> {
                        List list = fontrenderer.func_238425_b_((ITextProperties)ss, 75);
                        return list.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)list.get(0);
                    });
                    if (ireorderingprocessor == null) continue;
                    for (int v = 0; v < 2; ++v) {
                        matrixStackIn.func_227860_a_();
                        matrixStackIn.func_227861_a_(0.0, 0.0, 6.479999806880957);
                        float f3 = -fontrenderer.func_243245_a(ireorderingprocessor) / 2;
                        fontrenderer.func_238416_a_(ireorderingprocessor, f3, (float)(k1 * 10 - 34), i1, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
                        matrixStackIn.func_227865_b_();
                        matrixStackIn.func_227863_a_(Const.Y180);
                    }
                }
            }
        }
        matrixStackIn.func_227865_b_();
    }
}

