/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CompatObjects {
    public static final Supplier<Block> CHANDELIER = CompatObjects.makeCompatObject("decorative_blocks:chandelier", ForgeRegistries.BLOCKS);
    public static final Supplier<Block> SOUL_CHANDELIER = CompatObjects.makeCompatObject("decorative_blocks:soul_chandelier", ForgeRegistries.BLOCKS);
    public static final Supplier<Block> GLOW_CHANDELIER = CompatObjects.makeCompatObject("muchmoremodcompat:glow_chandelier", ForgeRegistries.BLOCKS);
    public static final Supplier<Block> ENDER_CHANDELIER = CompatObjects.makeCompatObject("decorative_blocks_abnormals:ender_chandelier", ForgeRegistries.BLOCKS);
    public static final Supplier<Block> SAPPY_MAPLE_LOG = CompatObjects.makeCompatObject("autumnity:sappy_maple_log", ForgeRegistries.BLOCKS);
    public static final Supplier<Block> SAPPY_MAPLE_WOOD = CompatObjects.makeCompatObject("autumnity:sappy_maple_wood", ForgeRegistries.BLOCKS);
    public static final Supplier<ParticleType<?>> ENDER_FLAME = CompatObjects.makeCompatObject("endergetic:ender_flame", ForgeRegistries.PARTICLE_TYPES);
    public static final Supplier<ParticleType<?>> GLOW_FLAME = CompatObjects.makeCompatObject("infernalexp:glowstone_sparkle", ForgeRegistries.PARTICLE_TYPES);
    public static final Supplier<Block> RICH_SOIL = CompatObjects.makeCompatObject("farmersdelight:rich_soil", ForgeRegistries.BLOCKS);
    public static final Supplier<Block> RICH_SOUL_SOIL = CompatObjects.makeCompatObject("nethers_delight:rich_soul_soil", ForgeRegistries.BLOCKS);

    private static <T extends IForgeRegistryEntry<T>, U extends T> NullableRegistryObject<T, U> makeCompatObject(String name, IForgeRegistry<T> registry) {
        return new NullableRegistryObject(CompatObjects.getRegistryObject(name, registry));
    }

    private static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> getRegistryObject(String name, IForgeRegistry<T> registry) {
        return RegistryObject.of((ResourceLocation)new ResourceLocation(name), registry);
    }

    private static class NullableRegistryObject<T extends IForgeRegistryEntry<T>, U extends T>
    implements Supplier<T> {
        private final RegistryObject<U> obj;

        private NullableRegistryObject(RegistryObject<U> obj) {
            this.obj = obj;
        }

        @Override
        @Nullable
        public T get() {
            return (T)this.obj.orElse(null);
        }
    }
}

