/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.mixins.MixinConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryConfigs {
    public static final String FILE_NAME = "supplementaries-registry.toml";
    public static ForgeConfigSpec REGISTRY_CONFIG;

    public static void createSpec() {
        ForgeConfigSpec.Builder REGISTRY_BUILDER = new ForgeConfigSpec.Builder();
        reg.init(REGISTRY_BUILDER);
        REGISTRY_CONFIG = REGISTRY_BUILDER.build();
    }

    public static void load() {
        CommentedFileConfig replacementConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve(FILE_NAME)).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        replacementConfig.load();
        replacementConfig.save();
        REGISTRY_CONFIG.setConfig((CommentedConfig)replacementConfig);
        reg.HAS_MINESHAFT_LANTERN = (Boolean)reg.COPPER_LANTERN_ENABLED.get();
        reg.HAS_STRONGHOLD_SCONCE = (Boolean)reg.SCONCE_ENABLED.get();
    }

    public static class reg {
        public static ForgeConfigSpec.BooleanValue FIREFLY_ENABLED;
        public static ForgeConfigSpec.BooleanValue PLANTER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue PEDESTAL_ENABLED;
        public static ForgeConfigSpec.BooleanValue WIND_VANE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ILLUMINATOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NOTICE_BOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRANK_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_ENABLED;
        public static ForgeConfigSpec.BooleanValue FAUCET_ENABLED;
        public static ForgeConfigSpec.BooleanValue TURN_TABLE_ENABLED;
        public static ForgeConfigSpec.BooleanValue PISTON_LAUNCHER_ENABLED;
        public static ForgeConfigSpec.BooleanValue SPEAKER_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue SIGN_POST_ENABLED;
        public static ForgeConfigSpec.BooleanValue HANGING_SIGN_ENABLED;
        public static ForgeConfigSpec.BooleanValue BELLOWS_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_GREEN_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDELABRA_ENABLED;
        public static ForgeConfigSpec.BooleanValue CAGE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ITEM_SHELF_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_LEVER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDLE_HOLDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue COG_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue STONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue END_STONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKSTONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue DEEPSLATE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue GLOBE_ENABLED;
        public static ForgeConfigSpec.BooleanValue HOURGLASS_ENABLED;
        public static ForgeConfigSpec.BooleanValue LASER_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAG_ENABLED;
        public static ForgeConfigSpec.BooleanValue SACK_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue SAFE_ENABLED;
        public static ForgeConfigSpec.BooleanValue COPPER_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLUTE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue BAMBOO_SPIKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue TIPPED_SPIKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue CHECKERBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue NETHERITE_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NETHERITE_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue PANCAKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue LOCK_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAX_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROPE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROPE_ARROW_ENABLED;
        public static ForgeConfigSpec.BooleanValue PULLEY_ENABLED;
        public static ForgeConfigSpec.BooleanValue FODDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue BOMB_ENABLED;
        public static ForgeConfigSpec.BooleanValue MAGMA_CREAM_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRIMSON_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue STICK_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROD_ENABLED;
        public static ForgeConfigSpec.BooleanValue DAUB_ENABLED;
        public static ForgeConfigSpec.BooleanValue WATTLE_AND_DAUB_ENABLED;
        public static ForgeConfigSpec.BooleanValue TIMBER_FRAME_ENABLED;
        public static ForgeConfigSpec.BooleanValue TILE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOBLET_ENABLED;
        public static ForgeConfigSpec.BooleanValue RAKED_GRAVEL_ENABLED;
        public static ForgeConfigSpec.BooleanValue STATUE_ENABLED;
        public static ForgeConfigSpec.BooleanValue IRON_GATE_ENABLED;
        public static ForgeConfigSpec.BooleanValue FEATHER_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLINT_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue SLINGSHOT_ENABLED;
        public static ForgeConfigSpec.BooleanValue SHULKER_HELMET_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDY_ENABLED;
        public static ForgeConfigSpec.BooleanValue AMETHYST_ARROW_ENABLED;
        public static ForgeConfigSpec.BooleanValue PRESENT_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_TAB;
        public static ForgeConfigSpec.BooleanValue CREATIVE_TAB;
        public static ForgeConfigSpec.BooleanValue DISPENSERS;
        public static ForgeConfigSpec.BooleanValue CUSTOM_CONFIGURED_SCREEN;
        public static Lazy<Boolean> HAS_SILVER;
        public static Lazy<Boolean> HAS_BRASS;
        public static boolean HAS_MINESHAFT_LANTERN;
        public static boolean HAS_STRONGHOLD_SCONCE;
        public static final Map<String, ForgeConfigSpec.BooleanValue> MIXIN_VALUES;

        public static boolean isEnabled(String path) {
            switch (path) {
                case "wild_flax": {
                    return (Boolean)FLAX_ENABLED.get();
                }
                case "firefly_jar": {
                    return (Boolean)FIREFLY_ENABLED.get() != false && (Boolean)JAR_ENABLED.get() != false;
                }
                case "brass_lantern": {
                    return (Boolean)HAS_BRASS.get();
                }
                case "candelabra_silver": {
                    return (Boolean)CANDELABRA_ENABLED.get() != false && (Boolean)HAS_SILVER.get() != false;
                }
                case "soul_jar": {
                    return (Boolean)JAR_ENABLED.get();
                }
                case "key": {
                    return (Boolean)NETHERITE_DOOR_ENABLED.get() != false || (Boolean)NETHERITE_TRAPDOOR_ENABLED.get() != false || (Boolean)SAFE_ENABLED.get() != false;
                }
            }
            for (Field f : reg.class.getDeclaredFields()) {
                try {
                    ForgeConfigSpec.BooleanValue b;
                    String p;
                    if (!ForgeConfigSpec.BooleanValue.class.isAssignableFrom(f.getType()) || !(p = (String)(b = (ForgeConfigSpec.BooleanValue)f.get(null)).getPath().get(b.getPath().size() - 1)).equals(path)) continue;
                    return (Boolean)b.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        private static void init(ForgeConfigSpec.Builder builder) {
            builder.comment("Here are configs that need reloading to take effect").push("initialization");
            builder.push("general");
            CREATIVE_TAB = builder.comment("Enable Creative Tab").define("creative_tab", false);
            DISPENSERS = builder.comment("Set to false to disable custom dispenser behaviors (i.e: filling jars) if for some reason they are causing trouble").define("dispensers", true);
            JAR_TAB = builder.comment("Creates a creative tab full of filled jars").define("jar_tab", false);
            CUSTOM_CONFIGURED_SCREEN = builder.comment("Enables custom Configured config screen").define("custom_configured_screen", true);
            builder.pop();
            builder.push("blocks");
            PLANTER_ENABLED = builder.define("planter", true);
            CLOCK_ENABLED = builder.define("clock_block", true);
            PEDESTAL_ENABLED = builder.define("pedestal", true);
            WIND_VANE_ENABLED = builder.define("wind_vane", true);
            ILLUMINATOR_ENABLED = builder.define("redstone_illuminator", true);
            NOTICE_BOARD_ENABLED = builder.define("notice_board", true);
            CRANK_ENABLED = builder.define("crank", true);
            JAR_ENABLED = builder.define("jar", true);
            FAUCET_ENABLED = builder.define("faucet", true);
            TURN_TABLE_ENABLED = builder.define("turn_table", true);
            PISTON_LAUNCHER_ENABLED = builder.define("spring_launcher", true);
            SPEAKER_BLOCK_ENABLED = builder.define("speaker_block", true);
            SIGN_POST_ENABLED = builder.define("sign_post", true);
            HANGING_SIGN_ENABLED = builder.define("hanging_sign", true);
            BELLOWS_ENABLED = builder.define("bellows", true);
            SCONCE_ENABLED = builder.define("sconce", true);
            SCONCE_GREEN_ENABLED = builder.define("sconce_green", false);
            CANDELABRA_ENABLED = builder.define("candelabra", true);
            CAGE_ENABLED = builder.define("cage", true);
            ITEM_SHELF_ENABLED = builder.define("item_shelf", true);
            SCONCE_LEVER_ENABLED = builder.define("sconce_lever", true);
            COG_BLOCK_ENABLED = builder.define("cog_block", true);
            CANDLE_HOLDER_ENABLED = builder.define("candle_holder", true);
            GLOBE_ENABLED = builder.define("globe", true);
            HOURGLASS_ENABLED = builder.define("hourglass", true);
            SACK_ENABLED = builder.define("sack", true);
            BLACKBOARD_ENABLED = builder.define("blackboard", true);
            SAFE_ENABLED = builder.define("safe", true);
            COPPER_LANTERN_ENABLED = builder.define("copper_lantern", true);
            FLUTE_ENABLED = builder.define("flute", true);
            GOLD_TRAPDOOR_ENABLED = builder.define("gold_trapdoor", true);
            GOLD_DOOR_ENABLED = builder.define("gold_door", true);
            BAMBOO_SPIKES_ENABLED = builder.define("bamboo_spikes", true);
            TIPPED_SPIKES_ENABLED = builder.define("bamboo_spikes_tipped", true);
            STONE_LAMP_ENABLED = builder.define("stone_lamp", true);
            END_STONE_LAMP_ENABLED = builder.define("end_stone_lamp", true);
            BLACKSTONE_LAMP_ENABLED = builder.define("blackstone_lamp", true);
            DEEPSLATE_LAMP_ENABLED = builder.define("deepslate_lamp", true);
            CHECKERBOARD_ENABLED = builder.define("checker_block", true);
            NETHERITE_DOOR_ENABLED = builder.define("netherite_door", true);
            NETHERITE_TRAPDOOR_ENABLED = builder.define("netherite_trapdoor", true);
            PANCAKES_ENABLED = builder.define("pancake", true);
            LOCK_BLOCK_ENABLED = builder.define("lock_block", true);
            FLAX_ENABLED = builder.define("flax", true);
            ROPE_ENABLED = builder.define("rope", true);
            ROPE_ARROW_ENABLED = builder.define("rope_arrow", true);
            PULLEY_ENABLED = builder.define("pulley_block", true);
            FODDER_ENABLED = builder.define("fodder", true);
            BOMB_ENABLED = builder.define("bomb", true);
            CRIMSON_LANTERN_ENABLED = builder.define("crimson_lantern", true);
            MAGMA_CREAM_BLOCK_ENABLED = builder.define("magma_cream_block", true);
            STICK_ENABLED = builder.define("stick", true);
            ROD_ENABLED = builder.define("blaze_rod", true);
            DAUB_ENABLED = builder.define("daub", true);
            WATTLE_AND_DAUB_ENABLED = builder.define("wattle_and_daub", true);
            TIMBER_FRAME_ENABLED = builder.define("timber_frame", true);
            FLAG_ENABLED = builder.define("flag", true);
            TILE_ENABLED = builder.define("stone_tile", true);
            GOBLET_ENABLED = builder.define("goblet", true);
            RAKED_GRAVEL_ENABLED = builder.define("raked_gravel", true);
            STATUE_ENABLED = builder.define("statue", true);
            IRON_GATE_ENABLED = builder.define("iron_gate", true);
            FEATHER_BLOCK_ENABLED = builder.define("feather_block", true);
            FLINT_BLOCK_ENABLED = builder.define("flint_block", true);
            SLINGSHOT_ENABLED = builder.define("slingshot", true);
            SHULKER_HELMET_ENABLED = builder.define("shulker_shell", true);
            CANDY_ENABLED = builder.define("candy", true);
            AMETHYST_ARROW_ENABLED = builder.comment("WIP").define("amethyst_arrow", false);
            PRESENT_ENABLED = builder.comment("WIP").define("present", true);
            LASER_ENABLED = builder.comment("WIP").define("laser_block", false);
            builder.pop();
            builder.push("entities");
            FIREFLY_ENABLED = builder.define("firefly", true);
            builder.pop();
            builder.comment("Here you can disable mixins if they clash with other mods ones").push("mixins");
            List<String> mixins = MixinConfig.getMixinClassesNames();
            for (String c : mixins) {
                MIXIN_VALUES.put(c, builder.define(c.replace("Mixin", ""), true));
            }
            builder.pop();
            builder.pop();
        }

        static {
            HAS_SILVER = Lazy.of(() -> {
                ModList ml = ModList.get();
                return ml.isLoaded("mysticalworld") || ml.isLoaded("immersiveengineering") || ml.isLoaded("bluepower") || ml.isLoaded("silents_mechanisms ") || ml.isLoaded("thermal") || ml.isLoaded("iceandfire") || ml.isLoaded("silentgems") || ml.isLoaded("occultism");
            });
            HAS_BRASS = Lazy.of(() -> ModList.get().isLoaded("create"));
            HAS_MINESHAFT_LANTERN = false;
            HAS_STRONGHOLD_SCONCE = false;
            MIXIN_VALUES = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        }
    }
}

