/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.datagen;

import net.mehvahdjukaar.supplementaries.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (IWoodType iWoodType : WoodTypes.TYPES.values()) {
        }
        for (DyeColor color : DyeColor.values()) {
            this.makePresentBlock(color);
        }
    }

    private ModelFile hangingSignModel(IWoodType wood, String baseName, String type) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_" + type + "_" + wood.getRegName())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + baseName + "_" + type + "_template")))).texture("particle", "blocks/hanging_signs/" + wood.getLocation() + "hanging_sign_front_" + wood.getRegName())).texture("0", "blocks/hanging_signs/" + wood.getLocation() + "hanging_sign_front_" + wood.getRegName())).texture("1", "blocks/hanging_signs/" + wood.getLocation() + "hanging_sign_details_" + wood.getRegName());
    }

    private void makeHangingSignsBlock(IWoodType wood) {
        this.getVariantBuilder((Block)ModRegistry.HANGING_SIGNS.get(wood).get()).forAllStatesExcept(state -> {
            String baseName = "hanging_sign";
            ModelFile model = this.hangingSignModel(wood, baseName, (Boolean)state.func_177229_b((Property)HangingSignBlock.TILE) != false ? "tile" : ((Integer)state.func_177229_b((Property)HangingSignBlock.EXTENSION)).toString());
            return ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build();
        }, new Property[]{HangingSignBlock.HANGING, HangingSignBlock.WATERLOGGED});
    }

    private void makePresentBlock(DyeColor color) {
        this.getVariantBuilder((Block)ModRegistry.PRESENTS.get(color).get()).forAllStatesExcept(state -> {
            String baseName = "present";
            ModelFile model = this.presentModel(color, baseName, (Boolean)state.func_177229_b((Property)PresentBlock.OPEN) != false ? "opened" : "closed");
            return ConfiguredModel.builder().modelFile(model).build();
        }, new Property[]{PresentBlock.WATERLOGGED});
    }

    private ModelFile presentModel(DyeColor color, String baseName, String type) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_" + type + "_" + color.func_176762_d())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + baseName + "_" + type + "_template")))).texture("particle", "blocks/presents/present_side_" + color.func_176762_d())).texture("side", "blocks/presents/present_side_" + color.func_176762_d())).texture("top", "blocks/presents/present_top_" + color.func_176762_d())).texture("bottom", "blocks/presents/present_bottom_" + color.func_176762_d())).texture("inside", "blocks/presents/present_inside_" + color.func_176762_d());
    }
}

