/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class ImprovedProjectileEntity
extends ProjectileItemEntity {
    private static final DataParameter<Byte> ID_FLAGS = EntityDataManager.func_187226_a(ImprovedProjectileEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public boolean touchedGround = false;
    public int groundTime = 0;
    protected int maxAge = 200;
    protected int maxGroundTime = 20;
    protected float waterDeceleration = 0.8f;

    protected ImprovedProjectileEntity(EntityType<? extends ProjectileItemEntity> type, World world) {
        super(type, world);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ProjectileItemEntity> type, double x, double y, double z, World world) {
        this(type, world);
        this.func_70107_b(x, y, z);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ProjectileItemEntity> type, LivingEntity thrower, World world) {
        this(type, thrower.func_226277_ct_(), thrower.func_226280_cw_() - (double)0.1f, thrower.func_226281_cx_(), world);
        this.func_212361_a((Entity)thrower);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID_FLAGS, (Object)0);
    }

    private void setFlag(int id, boolean value) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        if (value) {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 | id)));
        } else {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 & ~id)));
        }
    }

    public void setNoPhysics(boolean noPhysics) {
        this.field_70145_X = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return ((Byte)this.field_70180_af.func_187225_a(ID_FLAGS) & 2) != 0;
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        Vector3d movement = this.func_213322_ci();
        double velX = movement.field_72450_a;
        double velY = movement.field_72448_b;
        double velZ = movement.field_72449_c;
        boolean noPhysics = this.isNoPhysics();
        BlockPos blockpos = this.func_233580_cy_();
        BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        if (!(blockstate.isAir((IBlockReader)this.field_70170_p, blockpos) || noPhysics || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.touchedGround = true;
                break;
            }
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.touchedGround && !noPhysics) {
            ++this.groundTime;
        } else {
            this.groundTime = 0;
            this.func_234617_x_();
            Vector3d pos = this.func_213303_ch();
            boolean client = this.field_70170_p.field_72995_K;
            Vector3d newPos = pos.func_178787_e(movement);
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(pos, newPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !noPhysics) {
                newPos = raytraceresult.func_216347_e();
            }
            if (client) {
                this.spawnTrailParticles(pos, newPos);
            }
            double posX = newPos.field_72450_a;
            double posY = newPos.field_72448_b;
            double posZ = newPos.field_72449_c;
            float deceleration = this.getDeceleration();
            if (this.func_70090_H()) {
                if (client) {
                    for (int j = 0; j < 4; ++j) {
                        double pY = posY + (double)this.func_213302_cg() / 2.0;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX - velX * 0.25, pY - velY * 0.25, posZ - velZ * 0.25, velX, velY, velZ);
                    }
                }
                deceleration = this.waterDeceleration;
            }
            this.func_213317_d(movement.func_186678_a((double)deceleration));
            if (!this.func_189652_ae() && !noPhysics) {
                this.func_213293_j(velX, velY - (double)this.func_70185_h(), velZ);
            }
            this.func_70107_b(posX, posY, posZ);
            this.func_145775_I();
            if (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.findHitEntity(pos, newPos);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                RayTraceResult.Type type = raytraceresult.func_216346_c();
                boolean portalHit = false;
                if (type == RayTraceResult.Type.ENTITY) {
                    Entity entity2 = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity2 instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity2)) {
                        raytraceresult = null;
                    }
                } else if (type == RayTraceResult.Type.BLOCK) {
                    BlockPos hitPos = raytraceresult.func_216350_a();
                    BlockState hitState = this.field_70170_p.func_180495_p(hitPos);
                    if (hitState.func_203425_a(Blocks.field_150427_aO)) {
                        this.func_181015_d(hitPos);
                        portalHit = true;
                    } else if (hitState.func_203425_a(Blocks.field_185775_db)) {
                        TileEntity tileentity = this.field_70170_p.func_175625_s(hitPos);
                        if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                            ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                        }
                        portalHit = true;
                    }
                }
                if (!(raytraceresult == null || portalHit || type == RayTraceResult.Type.MISS || noPhysics || ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult))) {
                    this.func_70227_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
            }
        }
        if (this.hasReachedEndOfLife()) {
            this.reachedEndOfLife();
        }
    }

    protected float getDeceleration() {
        return 0.99f;
    }

    public boolean hasReachedEndOfLife() {
        return this.field_70173_aa > this.maxAge || this.groundTime > this.maxGroundTime;
    }

    public void reachedEndOfLife() {
        this.func_70106_y();
    }

    @Nullable
    protected EntityRayTraceResult findHitEntity(Vector3d oPos, Vector3d pos) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)oPos, (Vector3d)pos, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), arg_0 -> ((ImprovedProjectileEntity)this).func_230298_a_(arg_0));
    }

    public void spawnTrailParticles(Vector3d currentPos, Vector3d newPos) {
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("touchedGround", this.touchedGround);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.touchedGround = tag.func_74767_n("touchedGround");
    }
}

