/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.client.gui.ConfigButton;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkTooltipPlugin;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="supplementaries", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getPlayer() != null && event.getPlayer().field_70170_p != null) {
            if (ClientConfigs.cached.TOOLTIP_HINTS && Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                ItemsOverrideHandler.addOverrideTooltips(event);
            }
            if (CompatHandler.quark) {
                QuarkTooltipPlugin.onItemTooltipEvent(event);
            }
            if (event.getItemStack().func_77973_b() == ModRegistry.ROPE_ARROW_ITEM.get()) {
                List tooltip = event.getToolTip();
                Optional<ITextComponent> r = tooltip.stream().filter(t -> t instanceof TranslationTextComponent && ((TranslationTextComponent)t).func_150268_i().equals("item.durability")).findFirst();
                r.ifPresent(tooltip::remove);
            }
        }
    }

    @SubscribeEvent
    public static void renderTooltipEvent(RenderTooltipEvent.PostText event) {
        CompoundNBT cmp;
        ItemStack stack = event.getStack();
        Item i = stack.func_77973_b();
        if (CompatHandler.quark) {
            if (i == ModRegistry.SACK_ITEM.get()) {
                QuarkTooltipPlugin.renderTooltipEvent(event);
            } else if (i == ModRegistry.SAFE_ITEM.get()) {
                QuarkTooltipPlugin.renderTooltipEvent(event);
            }
        }
        if (i == ModRegistry.BLACKBOARD_ITEM.get() && (cmp = stack.func_179543_a("BlockEntityTag")) != null && cmp.func_74764_b("Pixels")) {
            long[] packed = cmp.func_197645_o("Pixels");
            Minecraft mc = Minecraft.func_71410_x();
            int pad = 7;
            float size = 135.0f;
            float scale = 0.5f;
            MatrixStack matrixStack = event.getMatrixStack();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(BlackboardTextureManager.INSTANCE.getResourceLocation(packed));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            matrixStack.func_227861_a_((double)event.getX(), (double)((float)event.getY() - size * scale - 5.0f), 500.0);
            matrixStack.func_227862_a_(scale, scale, 1.0f);
            RenderSystem.enableBlend();
            Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_227888_a_(mat, (float)(-pad), size, 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(mat, size, size, 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(mat, size, (float)(-pad), 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(mat, (float)(-pad), (float)(-pad), 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent event) {
        if (!ClientConfigs.cached.CONFIG_BUTTON) {
            return;
        }
        if (!CompatHandler.configured) {
            return;
        }
        ConfigButton.setupConfigButton(event);
    }
}

