/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.List;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.util.PotionNBTHelper;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.botania.BotaniaCompatRegistry;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.fluids.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.items.tabs.JarTab;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class JarItem
extends AbstractMobContainerItem {
    public JarItem(Block blockIn, Item.Properties properties) {
        super(blockIn, properties, 0.625f, 0.875f, true);
    }

    @Override
    public boolean canItemCatch(Entity e) {
        EntityType type = e.func_200600_R();
        if (e instanceof MonsterEntity) {
            return false;
        }
        if (ServerConfigs.cached.JAR_AUTO_DETECT && this.canFitEntity(e)) {
            return true;
        }
        return this.isFirefly(e) || type.func_220341_a(ModTags.JAR_CATCHABLE) || this.isBoat(e) || CapturedMobsHelper.CATCHABLE_FISHES.contains(type.getRegistryName().toString());
    }

    @Override
    public void playReleaseSound(World world, Vector3d v) {
        world.func_184148_a(null, v.func_82615_a(), v.func_82617_b(), v.func_82616_c(), SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 0.05f);
    }

    @Override
    public void playCatchSound(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public ItemStack captureEntityInItem(Entity entity2, ItemStack currentStack, ItemStack bucket) {
        if (this.isFirefly(entity2)) {
            return new ItemStack((IItemProvider)ModRegistry.FIREFLY_JAR_ITEM.get());
        }
        if (this.isBoat(entity2)) {
            return new ItemStack((IItemProvider)ModRegistry.JAR_BOAT_ITEM.get());
        }
        return super.captureEntityInItem(entity2, currentStack, bucket);
    }

    public boolean isFirefly(Entity e) {
        return e.func_200600_R().getRegistryName().func_110623_a().toLowerCase().contains("firefl");
    }

    public boolean isBoat(Entity e) {
        return e instanceof BoatEntity;
    }

    @Override
    public ActionResultType doInteract(ItemStack stack, PlayerEntity player, Entity entity2, Hand hand) {
        return super.doInteract(stack, player, entity2, hand);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt == null) {
            if (!ClientConfigs.cached.TOOLTIP_HINTS || !Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                return;
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.jar").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        } else {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????").func_240699_a_(TextFormatting.GRAY));
            }
            if (compoundnbt.func_74764_b("FluidHolder")) {
                CompoundNBT com = compoundnbt.func_74775_l("FluidHolder");
                SoftFluid s = SoftFluidRegistry.get((String)com.func_74779_i("Fluid"));
                int count = com.func_74762_e("Count");
                if (!s.isEmpty() && count > 0) {
                    String bottle;
                    CompoundNBT nbt = null;
                    String add = "";
                    if (com.func_74764_b("NBT") && (nbt = com.func_74775_l("NBT")).func_74764_b("Bottle") && !(bottle = nbt.func_74779_i("Bottle").toLowerCase()).equals("regular")) {
                        add = "_" + bottle;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.fluid_tooltip", new Object[]{new TranslationTextComponent(s.getTranslationKey() + add), count}).func_240699_a_(TextFormatting.GRAY));
                    if (nbt != null) {
                        PotionNBTHelper.addPotionTooltip((CompoundNBT)nbt, tooltip, (float)1.0f);
                        return;
                    }
                }
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                    String s = iformattabletextcomponent.getString();
                    s = s.replace(" Bucket", "");
                    s = s.replace(" Bottle", "");
                    s = s.replace("Bucket of ", "");
                    StringTextComponent str = new StringTextComponent(s);
                    str.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add((ITextComponent)str.func_240699_a_(TextFormatting.GRAY));
                }
                if (j - i > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items2) {
        if (((Boolean)RegistryConfigs.reg.JAR_TAB.get()).booleanValue()) {
            if (group == ModRegistry.JAR_TAB) {
                JarTab.populateTab(items2);
            }
        } else {
            super.func_150895_a(group, items2);
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        CompoundNBT com;
        SoftFluid s;
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && tag.func_74764_b("FluidHolder") && (s = SoftFluidRegistry.get((String)(com = tag.func_74775_l("FluidHolder")).func_74779_i("Fluid"))) == ModSoftFluids.DIRT) {
            return Rarity.RARE;
        }
        return super.func_77613_e(stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity2) {
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && entity2 instanceof PlayerEntity) {
            JarBlockTile temp = new JarBlockTile();
            temp.func_230337_a_(((Block)ModRegistry.JAR.get()).func_176223_P(), tag);
            SoftFluidHolder fh = temp.getSoftFluidHolder();
            if (fh.containsFood() && fh.tryDrinkUpFluid((PlayerEntity)entity2, world)) {
                CompoundNBT newTag = new CompoundNBT();
                temp.func_189515_b(newTag);
                stack.func_77983_a("BlockEntityTag", (INBT)newTag);
                return stack;
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        if (this.func_77626_a(playerEntity.func_184586_b(hand)) != 0) {
            return DrinkHelper.func_234707_a_((World)world, (PlayerEntity)playerEntity, (Hand)hand);
        }
        return super.func_77659_a(world, playerEntity, hand);
    }

    public int func_77626_a(ItemStack stack) {
        CompoundNBT tag;
        if (ServerConfigs.cached.JAR_ITEM_DRINK && (tag = stack.func_179543_a("BlockEntityTag")) != null) {
            JarBlockTile temp = new JarBlockTile();
            temp.func_230337_a_(((Block)ModRegistry.JAR.get()).func_176223_P(), tag);
            SoftFluidHolder fh = temp.getSoftFluidHolder();
            SoftFluid sf = fh.getFluid();
            Item food = sf.getFoodItem();
            return food.func_77626_a(food.func_190903_i()) / sf.getFoodDivider();
        }
        return 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (ServerConfigs.cached.JAR_ITEM_DRINK) {
            return UseAction.DRINK;
        }
        return UseAction.NONE;
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType r;
        if (CompatHandler.botania && this == ModRegistry.JAR_ITEM.get() && (r = BotaniaCompatRegistry.tryCaptureTater(this, context)).func_226246_a_()) {
            return r;
        }
        return super.func_195939_a(context);
    }
}

