/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.network.shared.flushconsolidation;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import me.steinborn.krypton.mod.shared.network.ConfigurableAutoFlush;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={NetworkManager.class})
public abstract class ClientConnectionMixin
implements ConfigurableAutoFlush {
    @Shadow
    private Channel field_150746_k;
    private AtomicBoolean autoFlush;
    @Shadow
    @Final
    private static Logger field_150735_g;

    @Shadow
    public abstract void func_150723_a(ProtocolType var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddedFields(CallbackInfo ci) {
        this.autoFlush = new AtomicBoolean(true);
    }

    @Inject(locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, method={"sendPacket"}, at={@At(value="FIELD", target="Lnet/minecraft/network/NetworkManager;sentPackets:I", opcode=180, shift=At.Shift.AFTER)})
    private void sendImmediately$rewrite(IPacket<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, CallbackInfo info, ProtocolType packetState, ProtocolType protocolState) {
        boolean newState;
        boolean bl = newState = packetState != protocolState;
        if (this.field_150746_k.eventLoop().inEventLoop()) {
            if (newState) {
                this.func_150723_a(packetState);
            }
            this.doSendPacket(packet, callback);
        } else if (!newState && callback == null) {
            ChannelPromise voidPromise = this.field_150746_k.voidPromise();
            if (this.autoFlush.get()) {
                this.field_150746_k.writeAndFlush(packet, voidPromise);
            } else {
                this.field_150746_k.write(packet, voidPromise);
            }
        } else {
            if (newState) {
                this.field_150746_k.config().setAutoRead(false);
            }
            this.field_150746_k.eventLoop().execute(() -> {
                if (newState) {
                    this.func_150723_a(packetState);
                }
                this.doSendPacket(packet, callback);
            });
        }
        info.cancel();
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/network/NetworkManager;channel:Lio/netty/channel/Channel;", opcode=180))
    public Channel disableForcedFlushEveryTick(NetworkManager clientConnection) {
        return null;
    }

    private void doSendPacket(IPacket<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        if (callback == null) {
            this.field_150746_k.write(packet, this.field_150746_k.voidPromise());
        } else {
            ChannelFuture channelFuture = this.field_150746_k.write(packet);
            channelFuture.addListener(callback);
            channelFuture.addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        if (this.autoFlush.get()) {
            this.field_150746_k.flush();
        }
    }

    @Override
    public void setShouldAutoFlush(boolean shouldAutoFlush) {
        boolean prev = this.autoFlush.getAndSet(shouldAutoFlush);
        if (!prev && shouldAutoFlush) {
            this.field_150746_k.flush();
        }
    }
}

