/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mod.shared.network.compression;

import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class MinecraftCompressDecoder
extends ByteToMessageDecoder {
    private static final int VANILLA_MAXIMUM_UNCOMPRESSED_SIZE = 0x200000;
    private static final int HARD_MAXIMUM_UNCOMPRESSED_SIZE = 0x1000000;
    private static final int UNCOMPRESSED_CAP = Boolean.getBoolean("velocity.increased-compression-cap") ? 0x1000000 : 0x200000;
    private final int threshold;
    private final VelocityCompressor compressor;

    public MinecraftCompressDecoder(int threshold, VelocityCompressor compressor) {
        this.threshold = threshold;
        this.compressor = compressor;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() != 0) {
            PacketBuffer packetBuf = new PacketBuffer(in);
            int claimedUncompressedSize = packetBuf.func_150792_a();
            if (claimedUncompressedSize == 0) {
                out.add(packetBuf.readBytes(packetBuf.readableBytes()));
            } else {
                if (claimedUncompressedSize < this.threshold) {
                    throw new DecoderException("Badly compressed packet - size of " + claimedUncompressedSize + " is below server threshold of " + this.threshold);
                }
                if (claimedUncompressedSize > UNCOMPRESSED_CAP) {
                    throw new DecoderException("Badly compressed packet - size of " + claimedUncompressedSize + " is larger than maximum of " + UNCOMPRESSED_CAP);
                }
                ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible(ctx.alloc(), this.compressor, in);
                ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer(ctx.alloc(), this.compressor, claimedUncompressedSize);
                try {
                    this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
                    out.add(uncompressed);
                    in.clear();
                }
                catch (Exception e) {
                    uncompressed.release();
                    throw e;
                }
                finally {
                    compatibleIn.release();
                }
            }
        }
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
    }
}

