/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.ClientProxy;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackBackgroundProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackGuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeSettingsTabControl;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackInventorySlot;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.TransferFullSlotMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.WindowClickMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.crafting.ICraftingUIPart;
import net.p3pp3rf1y.sophisticatedbackpacks.util.CountAbbreviator;

public class BackpackScreen
extends ContainerScreen<BackpackContainer> {
    private static final int DISABLED_SLOT_COLOR = -1072689136;
    private static final int UPGRADE_TOP_HEIGHT = 7;
    private static final int UPGRADE_SLOT_HEIGHT = 18;
    private static final int UPGRADE_SPACE_BETWEEN_SLOTS = 4;
    private static final int UPGRADE_BOTTOM_HEIGHT = 7;
    private static final int TOTAL_UPGRADE_GUI_HEIGHT = 252;
    public static final int UPGRADE_INVENTORY_OFFSET = 26;
    public static final int DISABLED_SLOT_X_POS = -1000;
    static final int SLOTS_Y_OFFSET = 17;
    static final int SLOTS_X_OFFSET = 7;
    private static IButtonReplacer buttonReplacer = new IButtonReplacer(){};
    private UpgradeSettingsTabControl settingsTabControl;
    private final int numberOfUpgradeSlots;
    @Nullable
    private Button sortButton = null;
    @Nullable
    private ToggleButton<SortBy> sortByButton = null;
    private final Set<ToggleButton<Boolean>> upgradeSwitches = new HashSet<ToggleButton<Boolean>>();
    private final Map<Integer, UpgradeInventoryPartBase<?>> inventoryParts = new LinkedHashMap();
    private static ICraftingUIPart craftingUIPart = ICraftingUIPart.NOOP;
    public static final int ERROR_BACKGROUND_COLOR = -267386864;
    public static final int ERROR_BORDER_COLOR = DyeColor.RED.getColorValue() | 0xFF000000;

    public static void setButtonReplacer(IButtonReplacer replacer) {
        buttonReplacer = replacer;
    }

    public static BackpackScreen constructScreen(BackpackContainer screenContainer, PlayerInventory inv, ITextComponent title) {
        return new BackpackScreen(screenContainer, inv, title);
    }

    public static void setCraftingUIPart(ICraftingUIPart part) {
        craftingUIPart = part;
    }

    public BackpackScreen(BackpackContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_147000_g = 114 + ((BackpackContainer)this.func_212873_a_()).getNumberOfRows() * 18;
        this.field_146999_f = ((BackpackContainer)this.func_212873_a_()).getBackpackBackgroundProperties().getSlotsOnLine() * 18 + 14;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.field_238744_r_ = 8 + ((BackpackContainer)this.func_212873_a_()).getBackpackBackgroundProperties().getPlayerInventoryXOffset();
        this.numberOfUpgradeSlots = ((BackpackContainer)this.func_212873_a_()).getNumberOfUpgradeSlots();
        this.field_230711_n_ = true;
    }

    public ICraftingUIPart getCraftingUIAddition() {
        return craftingUIPart;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        craftingUIPart.setBackpackScreen(this);
        this.initUpgradeSettingsControl();
        this.initUpgradeInventoryParts();
        this.addUpgradeSwitches();
        ((BackpackContainer)this.func_212873_a_()).setUpgradeChangeListener(c -> {
            this.field_230705_e_.remove((Object)this.settingsTabControl);
            craftingUIPart.onCraftingSlotsHidden();
            this.initUpgradeSettingsControl();
            this.initUpgradeInventoryParts();
            this.addUpgradeSwitches();
        });
        this.addSortButtons();
    }

    protected <T extends Widget> T func_230480_a_(T widget) {
        if (!(widget instanceof net.minecraft.client.gui.widget.button.Button)) {
            return widget;
        }
        net.minecraft.client.gui.widget.button.Button button = (net.minecraft.client.gui.widget.button.Button)widget;
        if (buttonReplacer.shouldReplace(this, button)) {
            return (T)super.func_230480_a_((Widget)buttonReplacer.replace(this, button));
        }
        return (T)super.func_230480_a_(widget);
    }

    private void initUpgradeInventoryParts() {
        this.inventoryParts.clear();
        if (((BackpackContainer)this.func_212873_a_()).getColumnsTaken() == 0) {
            return;
        }
        AtomicReference<Position> pos = new AtomicReference<Position>(new Position(7 + ((BackpackContainer)this.field_147002_h).getSlotsOnLine() * 18, 17));
        int height = ((BackpackContainer)this.field_147002_h).getNumberOfRows() * 18;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((BackpackContainer)this.func_212873_a_()).getUpgradeContainers().entrySet()) {
            UpgradeContainerBase<?, ?> container = entry.getValue();
            UpgradeGuiManager.getInventoryPart(entry.getKey(), container, pos.get(), height, this).ifPresent(part -> {
                this.inventoryParts.put((Integer)entry.getKey(), (UpgradeInventoryPartBase<?>)part);
                pos.set(new Position(((Position)pos.get()).getX() + 36, ((Position)pos.get()).getY()));
            });
        }
    }

    private void addUpgradeSwitches() {
        this.upgradeSwitches.clear();
        int switchTop = this.field_147009_r + this.getUpgradeTop() + 10;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((BackpackContainer)this.field_147002_h).canDisableUpgrade(slot)) {
                int finalSlot = slot;
                ToggleButton<Boolean> upgradeSwitch = new ToggleButton<Boolean>(new Position(this.field_147003_i - 22, switchTop), ButtonDefinitions.UPGRADE_SWITCH, button -> ((BackpackContainer)this.func_212873_a_()).setUpgradeEnabled(finalSlot, !((BackpackContainer)this.func_212873_a_()).getUpgradeEnabled(finalSlot)), () -> ((BackpackContainer)this.func_212873_a_()).getUpgradeEnabled(finalSlot));
                this.func_230481_d_(upgradeSwitch);
                this.upgradeSwitches.add(upgradeSwitch);
            }
            switchTop += 22;
        }
    }

    private void addSortButtons() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        if (sortButtonsPosition == SortButtonsPosition.HIDDEN) {
            return;
        }
        Position pos = this.getSortButtonsPosition(sortButtonsPosition);
        this.sortButton = new Button(new Position(pos.getX(), pos.getY()), ButtonDefinitions.SORT, button -> {
            if (button == 0) {
                ((BackpackContainer)this.func_212873_a_()).sort();
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Sorted"), true);
            }
        });
        this.func_230481_d_(this.sortButton);
        this.sortByButton = new ToggleButton<SortBy>(new Position(pos.getX() + 14, pos.getY()), ButtonDefinitions.SORT_BY, button -> {
            if (button == 0) {
                ((BackpackContainer)this.func_212873_a_()).setSortBy(((BackpackContainer)this.func_212873_a_()).getSortBy().next());
            }
        }, () -> ((BackpackContainer)this.func_212873_a_()).getSortBy());
        this.func_230481_d_(this.sortByButton);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || ClientProxy.BACKPACK_OPEN_KEYBIND.isActiveAndMatches(InputMappings.func_197954_a((int)keyCode, (int)scanCode)) && this.mouseNotOverBackpack()) {
            if (((BackpackContainer)this.func_212873_a_()).isFirstLevelBackpack() && ((BackpackContainer)this.func_212873_a_()).getBackpackContext().wasOpenFromInventory()) {
                this.getMinecraft().field_71439_g.func_71053_j();
                this.getMinecraft().func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.getMinecraft().field_71439_g));
                return true;
            }
            if (!((BackpackContainer)this.func_212873_a_()).isFirstLevelBackpack()) {
                PacketHandler.sendToServer(new BackpackOpenMessage());
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private boolean mouseNotOverBackpack() {
        Slot selectedSlot = this.getSlotUnderMouse();
        return selectedSlot == null || !(selectedSlot.func_75211_c().func_77973_b() instanceof BackpackItem);
    }

    private Position getSortButtonsPosition(SortButtonsPosition sortButtonsPosition) {
        switch (sortButtonsPosition) {
            case ABOVE_UPGRADES: {
                return new Position(this.field_147003_i - 26 - 2, this.field_147009_r + this.getUpgradeTop() - 14);
            }
            case BELOW_UPGRADES: {
                return new Position(this.field_147003_i - 26 - 2, this.field_147009_r + this.getUpgradeTop() + this.getUpgradeHeightWithoutBottom() + 7 + 2);
            }
            case BELOW_UPGRADE_TABS: {
                return this.settingsTabControl == null ? new Position(0, 0) : new Position(this.settingsTabControl.getX() + 2, this.settingsTabControl.getY() + Math.max(0, this.settingsTabControl.getHeight() + 2));
            }
        }
        return new Position(this.field_147003_i + this.field_146999_f - 34, this.field_147009_r + 4);
    }

    public Optional<Rectangle2d> getSortButtonsRectangle() {
        return this.sortButton == null || this.sortByButton == null ? Optional.empty() : Optional.of(new Rectangle2d(this.sortButton.getX(), this.sortButton.getY(), this.sortByButton.getX() + this.sortByButton.getWidth() - this.sortButton.getX(), this.sortByButton.getY() + this.sortByButton.getHeight() - this.sortButton.getY()));
    }

    private void initUpgradeSettingsControl() {
        this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.field_147003_i + this.field_146999_f, this.field_147009_r + 4), this);
        this.func_230481_d_(this.settingsTabControl);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((BackpackContainer)this.field_147002_h).detectSettingsChangeAndReload();
        this.func_230446_a_(matrixStack);
        this.settingsTabControl.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227861_a_(0.0, 0.0, 200.0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.settingsTabControl.afterScreenRender(matrixStack, mouseX, mouseY, partialTicks);
        if (this.sortButton != null && this.sortByButton != null) {
            this.sortButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.sortByButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.upgradeSwitches.forEach(us -> us.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        this.renderErrorOverlay(matrixStack);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.renderUpgradeInventoryParts(matrixStack, mouseX, mouseY);
        this.renderUpgradeSlots(matrixStack, mouseX, mouseY);
        this.renderRealInventorySlots(matrixStack, mouseX, mouseY);
    }

    private void renderUpgradeInventoryParts(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.inventoryParts.values().forEach(ip -> ip.render(matrixStack, mouseX, mouseY));
    }

    private void renderRealInventorySlots(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((BackpackContainer)this.field_147002_h).realInventorySlots.size(); ++slotId) {
            Slot slot = ((BackpackContainer)this.field_147002_h).realInventorySlots.get(slotId);
            this.func_238746_a_(matrixStack, slot);
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            this.field_147006_u = slot;
            this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
        }
    }

    private void renderUpgradeSlots(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((BackpackContainer)this.field_147002_h).upgradeSlots.size(); ++slotId) {
            Slot slot = ((BackpackContainer)this.field_147002_h).upgradeSlots.get(slotId);
            if (slot.field_75223_e != -1000) {
                this.func_238746_a_(matrixStack, slot);
                if (!slot.func_111238_b()) {
                    this.renderSlotOverlay(matrixStack, slot, -1072689136);
                }
            }
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            this.field_147006_u = slot;
            this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
        }
    }

    protected void func_238746_a_(MatrixStack matrixStack, Slot slot) {
        int i = slot.field_75223_e;
        int j = slot.field_75221_f;
        ItemStack itemstack = slot.func_75211_c();
        boolean flag = false;
        boolean rightClickDragging = slot == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack itemstack1 = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        String stackCountText = null;
        if (slot == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slot) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (BackpackContainer.canMergeItemToSlot(slot, itemstack1) && ((BackpackContainer)this.field_147002_h).func_94531_b(slot)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a((Set)this.field_147008_s, (int)this.field_146987_F, (ItemStack)itemstack, (int)(slot.func_75211_c().func_190926_b() ? 0 : slot.func_75211_c().func_190916_E()));
                int slotLimit = slot.func_178170_b(itemstack);
                if (itemstack.func_190916_E() > slotLimit) {
                    stackCountText = TextFormatting.YELLOW + CountAbbreviator.abbreviate(slotLimit);
                    itemstack.func_190920_e(slotLimit);
                }
            } else {
                this.field_147008_s.remove(slot);
                this.func_146980_g();
            }
        }
        this.func_230926_e_(100);
        this.field_230707_j_.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slot.func_111238_b()) {
            this.renderSlotBackground(matrixStack, slot, i, j);
        } else if (!rightClickDragging) {
            this.renderStack(matrixStack, i, j, itemstack, flag, stackCountText);
        }
        this.field_230707_j_.field_77023_b = 0.0f;
        this.func_230926_e_(0);
    }

    private void renderStack(MatrixStack matrixStack, int i, int j, ItemStack itemstack, boolean flag, @Nullable String stackCountText) {
        if (flag) {
            BackpackScreen.func_238467_a_((MatrixStack)matrixStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
        }
        RenderSystem.enableDepthTest();
        this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, itemstack, i, j);
        if (this.shouldUseSpecialCountRender(itemstack)) {
            this.field_230707_j_.func_180453_a(this.field_230712_o_, itemstack, i, j, "");
            if (stackCountText == null) {
                stackCountText = CountAbbreviator.abbreviate(itemstack.func_190916_E());
            }
            this.renderStackCount(stackCountText, i, j);
        } else {
            this.field_230707_j_.func_180453_a(this.field_230712_o_, itemstack, i, j, stackCountText);
        }
    }

    private void renderSlotBackground(MatrixStack matrixStack, Slot slot, int i, int j) {
        Optional<ItemStack> memorizedStack = ((BackpackContainer)this.func_212873_a_()).getMemorizedStackInSlot(slot.field_75222_d);
        if (memorizedStack.isPresent()) {
            this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, memorizedStack.get(), i, j);
            this.drawMemorizedStackOverlay(matrixStack, i, j);
        } else {
            Pair pair = slot.func_225517_c_();
            if (pair != null) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                this.field_230706_i_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
                BackpackScreen.func_238470_a_((MatrixStack)matrixStack, (int)i, (int)j, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            }
        }
    }

    private void drawMemorizedStackOverlay(MatrixStack matrixStack, int x, int y) {
        matrixStack.func_227860_a_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227731_j_();
        this.field_230706_i_.func_110434_K().func_110577_a(GuiHelper.GUI_CONTROLS);
        this.func_238474_b_(matrixStack, x, y, 77, 0, 16, 16);
        GlStateManager.func_227734_k_();
        GlStateManager.func_227737_l_();
        matrixStack.func_227865_b_();
    }

    private boolean shouldUseSpecialCountRender(ItemStack itemstack) {
        return itemstack.func_190916_E() > 99;
    }

    private void renderSlotOverlay(MatrixStack matrixStack, Slot slot, int slotColor) {
        this.renderOverlay(matrixStack, slotColor, slot.field_75223_e, slot.field_75221_f, 16, 16);
    }

    public void renderOverlay(MatrixStack matrixStack, int slotColor, int xPos, int yPos, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_238468_a_(matrixStack, xPos, yPos, xPos + width, yPos + height, slotColor, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.drawInventoryBackground(matrixStack);
        this.drawUpgradeBackground(matrixStack);
    }

    protected void func_230459_a_(MatrixStack matrixStack, int x, int y) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null) {
            INameableEmptySlot emptySlot;
            if (this.field_147006_u.func_75216_d()) {
                this.func_230457_a_(matrixStack, this.field_147006_u.func_75211_c(), x, y);
            } else if (this.field_147006_u instanceof INameableEmptySlot && (emptySlot = (INameableEmptySlot)this.field_147006_u).hasEmptyTooltip()) {
                this.renderWrappedToolTip(matrixStack, Collections.singletonList(emptySlot.getEmptyTooltip()), x, y, this.field_230712_o_);
            }
        }
        GuiHelper.renderTooltip(this.field_230706_i_, matrixStack, x, y);
    }

    public List<ITextComponent> func_231151_a_(ItemStack itemStack) {
        List ret = super.func_231151_a_(itemStack);
        if (itemStack.func_190916_E() > 999) {
            ret.add(new TranslationTextComponent("gui.sophisticatedbackpacks.tooltip.stack_count", new Object[]{new StringTextComponent(NumberFormat.getNumberInstance().format(itemStack.func_190916_E())).func_240699_a_(TextFormatting.DARK_AQUA)}).func_240699_a_(TextFormatting.GRAY));
        }
        return ret;
    }

    private void drawInventoryBackground(MatrixStack matrixStack) {
        BackpackBackgroundProperties backpackBackgroundProperties = ((BackpackContainer)this.func_212873_a_()).getBackpackBackgroundProperties();
        BackpackGuiHelper.renderBackpackBackground(new Position((this.field_230708_k_ - this.field_146999_f) / 2, (this.field_230709_l_ - this.field_147000_g) / 2), matrixStack, ((BackpackContainer)this.func_212873_a_()).getNumberOfSlots(), ((BackpackContainer)this.func_212873_a_()).getSlotsOnLine(), backpackBackgroundProperties.getTextureName(), this.field_146999_f, this.field_230706_i_, ((BackpackContainer)this.field_147002_h).getNumberOfRows());
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.getGuiLeft(), (float)this.getGuiTop(), (float)0.0f);
        for (int slotNumber = 0; slotNumber < ((BackpackContainer)this.field_147002_h).getNumberOfSlots(); ++slotNumber) {
            List<Integer> colors = ((BackpackContainer)this.field_147002_h).getSlotOverlayColors(slotNumber);
            if (colors.isEmpty()) continue;
            this.renderSlotOverlay(matrixStack, ((BackpackContainer)this.field_147002_h).func_75139_a(slotNumber), (int)(colors.get(0) | 0x50000000));
        }
        RenderSystem.popMatrix();
    }

    private void drawUpgradeBackground(MatrixStack matrixStack) {
        if (this.numberOfUpgradeSlots == 0) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiHelper.GUI_CONTROLS);
        int firstHalfHeight = this.getUpgradeHeightWithoutBottom();
        BackpackScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_147003_i - 26), (int)(this.field_147009_r + this.getUpgradeTop()), (float)0.0f, (float)0.0f, (int)29, (int)firstHalfHeight, (int)256, (int)256);
        BackpackScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_147003_i - 26), (int)(this.field_147009_r + this.getUpgradeTop() + firstHalfHeight), (float)0.0f, (float)245.0f, (int)29, (int)7, (int)256, (int)256);
    }

    public int getUpgradeTop() {
        return this.field_147000_g - 94 - this.getUpgradeHeight();
    }

    public int getUpgradeHeight() {
        return this.getUpgradeHeightWithoutBottom() + 7;
    }

    private int getUpgradeHeightWithoutBottom() {
        return 7 + this.numberOfUpgradeSlots * 18 + (this.numberOfUpgradeSlots - 1) * 4;
    }

    public UpgradeSettingsTabControl getUpgradeSettingsControl() {
        if (this.settingsTabControl == null) {
            this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.field_147003_i + this.field_146999_f, this.field_147009_r + 4), this);
        }
        return this.settingsTabControl;
    }

    @Nullable
    public Slot func_195360_a(double mouseX, double mouseY) {
        Slot slot;
        int i;
        for (i = 0; i < ((BackpackContainer)this.field_147002_h).upgradeSlots.size(); ++i) {
            slot = ((BackpackContainer)this.field_147002_h).upgradeSlots.get(i);
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            return slot;
        }
        for (i = 0; i < ((BackpackContainer)this.field_147002_h).realInventorySlots.size(); ++i) {
            slot = ((BackpackContainer)this.field_147002_h).realInventorySlots.get(i);
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            return slot;
        }
        return super.func_195360_a(mouseX, mouseY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        for (UpgradeInventoryPartBase<?> inventoryPart : this.inventoryParts.values()) {
            if (!inventoryPart.handleMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        Slot slot = this.func_195360_a(mouseX, mouseY);
        if (this.field_146993_M && slot != null && button == 0 && ((BackpackContainer)this.field_147002_h).func_94530_a(ItemStack.field_190927_a, slot) && BackpackScreen.func_231173_s_() && !this.field_146994_N.func_190926_b()) {
            for (Slot slot2 : ((BackpackContainer)this.field_147002_h).realInventorySlots) {
                if (slot2 == null || !slot2.func_82869_a((PlayerEntity)this.field_230706_i_.field_71439_g) || !slot2.func_75216_d() || !slot2.isSameInventory(slot) || !Container.func_94527_a((Slot)slot2, (ItemStack)this.field_146994_N, (boolean)true)) continue;
                this.func_184098_a(slot2, slot2.field_75222_d, button, ClickType.QUICK_MOVE);
            }
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    protected void func_184098_a(Slot slot, int slotNumber, int mouseButton, ClickType type) {
        if (type == ClickType.PICKUP_ALL && !((BackpackContainer)this.field_147002_h).getSlotUpgradeContainer(slot).map(c -> c.allowsPickupAll(slot)).orElse(true).booleanValue()) {
            type = ClickType.PICKUP;
        }
        if (slot != null) {
            slotNumber = slot.field_75222_d;
        }
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        short nextTransId = player.field_71070_bA.func_75136_a(player.field_71071_by);
        ItemStack itemstack = player.field_71070_bA.func_184996_a(slotNumber, mouseButton, type, (PlayerEntity)player);
        PacketHandler.sendToServer(new WindowClickMessage(((BackpackContainer)this.field_147002_h).field_75152_c, slotNumber, mouseButton, type, itemstack, nextTransId));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Slot slot = this.func_195360_a(mouseX, mouseY);
        if (BackpackScreen.func_231173_s_() && BackpackScreen.func_231172_r_() && slot instanceof BackpackInventorySlot && button == 0) {
            PacketHandler.sendToServer(new TransferFullSlotMessage(slot.field_75222_d));
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (IGuiEventListener child : this.field_230705_e_) {
            if (!child.func_231047_b_(mouseX, mouseY) || !child.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        Slot slot = this.func_195360_a(mouseX, mouseY);
        ItemStack itemstack = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147007_t && slot != null && !itemstack.func_190926_b() && (itemstack.func_190916_E() > this.field_147008_s.size() || this.field_146987_F == 2) && BackpackContainer.canMergeItemToSlot(slot, itemstack) && slot.func_75214_a(itemstack) && ((BackpackContainer)this.field_147002_h).func_94531_b(slot)) {
            this.field_147008_s.add(slot);
            this.func_146980_g();
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfUpgradeSlots(mouseX, mouseY) && this.hasClickedOutsideOfUpgradeSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfUpgradeSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.func_199315_b((int)mouseX, (int)mouseY));
    }

    private boolean hasClickedOutsideOfUpgradeSlots(double mouseX, double mouseY) {
        return this.getUpgradeSlotsRectangle().map(r -> r.func_199315_b((int)mouseX, (int)mouseY)).orElse(false) == false;
    }

    public Optional<Rectangle2d> getUpgradeSlotsRectangle() {
        return this.numberOfUpgradeSlots == 0 ? Optional.empty() : Optional.of(new Rectangle2d(this.field_147003_i - 26, this.field_147009_r + this.getUpgradeTop(), 32, this.getUpgradeHeight()));
    }

    private void renderStackCount(String count, int x, int y) {
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, (double)(this.field_230707_j_.field_77023_b + 200.0f));
        IRenderTypeBuffer.Impl renderBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.pushMatrix();
        float scale = Math.min(1.0f, 16.0f / (float)this.field_230712_o_.func_78256_a(count));
        if (scale < 1.0f) {
            RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        }
        this.field_230712_o_.func_228079_a_(count, ((float)(x + 19 - 2) - (float)this.field_230712_o_.func_78256_a(count) * scale) / scale, ((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale, 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderBuffer, false, 0, 0xF000F0);
        renderBuffer.func_228461_a_();
        RenderSystem.popMatrix();
    }

    protected void func_146980_g() {
        ItemStack cursorStack = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        if (!cursorStack.func_190926_b() && this.field_147007_t) {
            if (this.field_146987_F == 2) {
                this.field_146996_I = cursorStack.func_77976_d();
            } else {
                this.field_146996_I = cursorStack.func_190916_E();
                for (Slot slot : this.field_147008_s) {
                    ItemStack itemstack1 = cursorStack.func_77946_l();
                    ItemStack slotStack = slot.func_75211_c();
                    int slotStackCount = slotStack.func_190926_b() ? 0 : slotStack.func_190916_E();
                    Container.func_94525_a((Set)this.field_147008_s, (int)this.field_146987_F, (ItemStack)itemstack1, (int)slotStackCount);
                    int j = slot.func_178170_b(itemstack1);
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.field_146996_I -= itemstack1.func_190916_E() - slotStackCount;
                }
            }
        }
    }

    private void renderErrorOverlay(MatrixStack matrixStack) {
        ((BackpackContainer)this.field_147002_h).getErrorUpgradeSlotChangeResult().ifPresent(upgradeSlotChangeResult -> upgradeSlotChangeResult.getErrorMessage().ifPresent(overlayErrorMessage -> {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.getGuiLeft(), (float)this.getGuiTop(), (float)0.0f);
            upgradeSlotChangeResult.getErrorUpgradeSlots().forEach(slotIndex -> this.renderSlotOverlay(matrixStack, ((BackpackContainer)this.field_147002_h).func_75139_a(((BackpackContainer)this.field_147002_h).getFirstUpgradeSlot() + slotIndex), DyeColor.RED.getColorValue() | 0xAA000000));
            upgradeSlotChangeResult.getErrorInventorySlots().forEach(slotIndex -> {
                Slot slot = ((BackpackContainer)this.field_147002_h).func_75139_a((int)slotIndex);
                if (slot != null) {
                    this.renderSlotOverlay(matrixStack, slot, DyeColor.RED.getColorValue() | 0xAA000000);
                }
            });
            upgradeSlotChangeResult.getErrorInventoryParts().forEach(partIndex -> {
                if (this.inventoryParts.size() > partIndex) {
                    this.inventoryParts.get(partIndex).renderErrorOverlay(matrixStack);
                }
            });
            RenderSystem.popMatrix();
            this.renderErrorMessage(matrixStack, (ITextComponent)overlayErrorMessage);
        }));
    }

    private void renderErrorMessage(MatrixStack matrixStack, ITextComponent overlayErrorMessage) {
        RenderSystem.pushMatrix();
        RenderSystem.disableDepthTest();
        RenderSystem.translatef((float)((float)this.field_230708_k_ / 2.0f), (float)(this.field_147009_r + this.field_238745_s_ + 4), (float)300.0f);
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int tooltipWidth = this.field_230712_o_.func_238414_a_((ITextProperties)overlayErrorMessage);
        ArrayList<Object> wrappedTextLines = new ArrayList<Object>();
        int maxLineWidth = 260;
        if (tooltipWidth > maxLineWidth) {
            int wrappedTooltipWidth = 0;
            List wrappedLine = this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)overlayErrorMessage, maxLineWidth, Style.field_240709_b_);
            for (ITextProperties line : wrappedLine) {
                int lineWidth = this.field_230712_o_.func_238414_a_(line);
                if (lineWidth > wrappedTooltipWidth) {
                    wrappedTooltipWidth = lineWidth;
                }
                wrappedTextLines.add(line);
            }
            tooltipWidth = wrappedTooltipWidth;
        } else {
            wrappedTextLines.add(overlayErrorMessage);
        }
        int tooltipHeight = 8;
        if (wrappedTextLines.size() > 1) {
            tooltipHeight += 2 + (wrappedTextLines.size() - 1) * 10;
        }
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float leftX = (float)(-tooltipWidth) / 2.0f;
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, (int)leftX, 0, tooltipHeight, -267386864, ERROR_BORDER_COLOR, ERROR_BORDER_COLOR);
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixStack.func_227861_a_(0.0, 0.0, 400.0);
        GuiHelper.writeTooltipLines(wrappedTextLines, fontrenderer, leftX, 0, matrix4f, renderTypeBuffer, DyeColor.RED.getColorValue());
        renderTypeBuffer.func_228461_a_();
        RenderSystem.popMatrix();
    }

    public static interface IButtonReplacer {
        default public boolean shouldReplace(BackpackScreen screen, net.minecraft.client.gui.widget.button.Button button) {
            return false;
        }

        default public net.minecraft.client.gui.widget.button.Button replace(BackpackScreen screen, net.minecraft.client.gui.widget.button.Button button) {
            return button;
        }
    }
}

