/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackBackgroundProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.HighStackCountListener;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsContainer;

public class SettingsContainer
extends Container
implements IContextAwareContainer,
ISyncedContainer {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES;
    private final PlayerEntity player;
    private final BackpackContext backpackContext;
    private final IBackpackWrapper backpackWrapper;
    private final BackpackBackgroundProperties backpackBackgroundProperties;
    private final List<Slot> backpackInventorySlots = new ArrayList<Slot>();
    public final NonNullList<ItemStack> ghostItemStacks = NonNullList.func_191196_a();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    public final List<Slot> ghostSlots = new ArrayList<Slot>();
    private CompoundNBT lastSettingsNbt = null;

    protected SettingsContainer(int windowId, PlayerEntity player, BackpackContext backpackContext) {
        super((ContainerType)ModItems.SETTINGS_CONTAINER_TYPE.get(), windowId);
        this.player = player;
        this.backpackContext = backpackContext;
        this.backpackWrapper = backpackContext.getBackpackWrapper(player);
        this.backpackBackgroundProperties = this.getNumberOfSlots() + this.backpackWrapper.getColumnsTaken() * this.backpackWrapper.getNumberOfSlotRows() <= 81 ? BackpackBackgroundProperties.REGULAR : BackpackBackgroundProperties.WIDE;
        this.addBackpackInventorySlots();
        this.addSettingsContainers();
    }

    private void addSettingsContainers() {
        BackpackSettingsHandler settingsHandler = this.backpackWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainer.instantiateContainer(this, name, category)));
    }

    private void addBackpackInventorySlots() {
        BackpackInventoryHandler inventoryHandler = this.backpackWrapper.getInventoryHandler();
        int slotIndex = 0;
        int yPosition = 18;
        while (slotIndex < inventoryHandler.getSlots()) {
            int lineIndex = slotIndex % this.getSlotsOnLine();
            int finalSlotIndex = slotIndex++;
            this.backpackInventorySlots.add(this.func_75146_a((Slot)new ViewOnlyBackpackInventorySlot((IItemHandler)inventoryHandler, finalSlotIndex, lineIndex, yPosition)));
            if (slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75222_d = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.ghostItemStacks.add((Object)ItemStack.field_190927_a);
        return slot;
    }

    public void func_75142_b() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            ItemStack itemstack = this.ghostSlots.get(i).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.ghostItemStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            boolean clientStackChanged = !itemstack1.equals(itemstack, true);
            ItemStack itemstack2 = itemstack.func_77946_l();
            this.ghostItemStacks.set(i, (Object)itemstack2);
            if (!clientStackChanged) continue;
            for (IContainerListener icontainerlistener : this.field_75149_d) {
                icontainerlistener.func_71111_a((Container)this, i, itemstack2);
            }
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.backpackWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.backpackWrapper.getSettingsHandler().getNbt().func_74737_b();
            this.sendBackpackSettingsToClient();
        }
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.field_70170_p.field_72995_K) {
            this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
                BackpackStorage storage = BackpackStorage.get();
                if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                    this.backpackWrapper.getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                }
            });
        }
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
            CompoundNBT settingsContents = new CompoundNBT();
            CompoundNBT settingsNbt = this.backpackWrapper.getSettingsHandler().getNbt();
            if (!settingsNbt.isEmpty()) {
                settingsContents.func_218657_a("settings", (INBT)settingsNbt);
                PacketHandler.sendToClient((ServerPlayerEntity)this.player, new BackpackContentsMessage((UUID)uuid, settingsContents));
            }
        });
    }

    public void func_75132_a(IContainerListener listener) {
        if (listener instanceof ServerPlayerEntity && this.backpackWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
            super.func_75132_a((IContainerListener)new HighStackCountListener((ServerPlayerEntity)listener));
            return;
        }
        super.func_75132_a(listener);
    }

    public Slot func_75139_a(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.backpackWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterItem(slotId).map(ItemStack::new);
    }

    public int getSlotsOnLine() {
        return this.backpackBackgroundProperties.getSlotsOnLine() - this.backpackWrapper.getColumnsTaken();
    }

    public int getNumberOfSlots() {
        return this.backpackWrapper.getInventoryHandler().getSlots();
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    @Override
    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    public List<Slot> getBackpackInventorySlots() {
        return this.backpackInventorySlots;
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        String categoryName;
        if (data.func_74764_b("categoryName") && this.settingsContainers.containsKey(categoryName = data.func_74779_i("categoryName"))) {
            this.settingsContainers.get(categoryName).handleMessage(data);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    public BackpackBackgroundProperties getBackpackBackgroundProperties() {
        return this.backpackBackgroundProperties;
    }

    public static SettingsContainer fromBuffer(int windowId, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        return new SettingsContainer(windowId, playerInventory.field_70458_d, BackpackContext.fromBuffer(packetBuffer));
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public int getNumberOfRows() {
        return this.backpackWrapper.getNumberOfSlotRows();
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> void addFactory(ImmutableMap.Builder<String, ISettingsContainerFactory<?, ?>> builder, String categoryName, ISettingsContainerFactory<C, T> factory) {
        builder.put((Object)categoryName, factory);
    }

    private static <C extends ISettingsCategory> SettingsContainerBase<C> instantiateContainer(SettingsContainer settingsContainer, String name, C category) {
        return SettingsContainer.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        SettingsContainer.addFactory(builder, "backpack", BackpackSettingsContainer::new);
        SettingsContainer.addFactory(builder, "no_sort", NoSortSettingsContainer::new);
        SettingsContainer.addFactory(builder, "memory", MemorySettingsContainer::new);
        SETTINGS_CONTAINER_FACTORIES = builder.build();
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainer var1, String var2, C var3);
    }

    private static class ViewOnlyBackpackInventorySlot
    extends SlotItemHandler {
        public ViewOnlyBackpackInventorySlot(IItemHandler inventoryHandler, int slotIndex, int lineIndex, int yPosition) {
            super(inventoryHandler, slotIndex, 8 + lineIndex * 18, yPosition);
        }

        public boolean func_82869_a(PlayerEntity playerIn) {
            return false;
        }
    }
}

