/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.data.CopyBackpackDataFunction;

public class ModLoot {
    public static final LootFunctionType COPY_BACKPACK_DATA = new LootFunctionType((ILootSerializer)new CopyBackpackDataFunction.Serializer());
    private static final List<String> CHEST_TABLES = ImmutableList.of((Object)"abandoned_mineshaft", (Object)"bastion_treasure", (Object)"desert_pyramid", (Object)"end_city_treasure", (Object)"nether_bridge", (Object)"shipwreck_treasure", (Object)"simple_dungeon", (Object)"woodland_mansion");

    private ModLoot() {
    }

    public static void init() {
        Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation("sophisticatedbackpacks", "copy_backpack_data"), (Object)COPY_BACKPACK_DATA);
        MinecraftForge.EVENT_BUS.addListener(ModLoot::lootLoad);
    }

    public static void lootLoad(LootTableLoadEvent evt) {
        if (Boolean.FALSE.equals(Config.COMMON.chestLootEnabled.get())) {
            return;
        }
        String chestsPrefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(chestsPrefix) && CHEST_TABLES.contains(name.substring(chestsPrefix.length()))) {
            String file = name.substring("minecraft:".length());
            evt.getTable().addPool(ModLoot.getInjectPool(file));
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(ModLoot.getInjectEntry(entryName)).bonusRolls(0.0f, 1.0f).name("sophisticatedbackpacks_inject_pool").func_216044_b();
    }

    private static LootEntry.Builder<?> getInjectEntry(String name) {
        return TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("sophisticatedbackpacks", "inject/" + name)).func_216086_a(1);
    }
}

