/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;

public class InventoryInteractionMessage {
    private final BlockPos pos;
    private final Direction face;

    public InventoryInteractionMessage(BlockPos pos, Direction face) {
        this.pos = pos;
        this.face = face;
    }

    public static void encode(InventoryInteractionMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeLong(msg.pos.func_218275_a());
        packetBuffer.func_179249_a((Enum)msg.face);
    }

    public static InventoryInteractionMessage decode(PacketBuffer packetBuffer) {
        return new InventoryInteractionMessage(BlockPos.func_218283_e((long)packetBuffer.readLong()), (Direction)packetBuffer.func_179257_a(Direction.class));
    }

    static void onMessage(InventoryInteractionMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> InventoryInteractionMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(InventoryInteractionMessage msg, @Nullable ServerPlayerEntity sender) {
        if (sender == null) {
            return;
        }
        SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().runOnBackpacks((PlayerEntity)sender, (backpack, inventoryName, slot) -> {
            InventoryInteractionHelper.tryInventoryInteraction(msg.pos, sender.field_70170_p, backpack, msg.face, (PlayerEntity)sender);
            sender.func_226292_a_(Hand.MAIN_HAND, true);
            return true;
        });
    }
}

