/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHelper;

public class SyncContainerStacksMessage {
    private final int windowId;
    private final List<ItemStack> itemStacks;

    public SyncContainerStacksMessage(int windowId, List<ItemStack> itemStacks) {
        this.windowId = windowId;
        this.itemStacks = itemStacks;
    }

    public static void encode(SyncContainerStacksMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeByte(msg.windowId);
        packetBuffer.writeShort(msg.itemStacks.size());
        for (ItemStack itemstack : msg.itemStacks) {
            PacketHelper.writeItemStack(itemstack, packetBuffer);
        }
    }

    public static SyncContainerStacksMessage decode(PacketBuffer packetBuffer) {
        short windowId = packetBuffer.readUnsignedByte();
        int slots = packetBuffer.readShort();
        NonNullList itemStacks = NonNullList.func_191197_a((int)slots, (Object)ItemStack.field_190927_a);
        for (int j = 0; j < slots; ++j) {
            itemStacks.set(j, PacketHelper.readItemStack(packetBuffer));
        }
        return new SyncContainerStacksMessage(windowId, (List<ItemStack>)itemStacks);
    }

    static void onMessage(SyncContainerStacksMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncContainerStacksMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncContainerStacksMessage msg) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !(player.field_71070_bA instanceof BackpackContainer) || player.field_71070_bA.field_75152_c != msg.windowId) {
            return;
        }
        player.field_71070_bA.func_190896_a(msg.itemStacks);
    }
}

