/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.FeedingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FeedingUpgradeContainer
extends UpgradeContainerBase<FeedingUpgradeWrapper, FeedingUpgradeContainer> {
    private static final String DATA_HUNGER_LEVEL = "hungerLevel";
    private static final String DATA_FEED_IMMEDIATELY_WHEN_HURT = "feedImmediatelyWhenHurt";
    private final FilterLogicContainer<FilterLogic> filterLogicContainer = new FilterLogicContainer<FilterLogic>(() -> ((FeedingUpgradeWrapper)this.upgradeWrapper).getFilterLogic(), this, this.slots::add);

    public FeedingUpgradeContainer(PlayerEntity player, int containerId, FeedingUpgradeWrapper wrapper, UpgradeContainerType<FeedingUpgradeWrapper, FeedingUpgradeContainer> type) {
        super(player, containerId, wrapper, type);
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_HUNGER_LEVEL)) {
            this.setFeedAtHungerLevel(HungerLevel.fromName(data.func_74779_i(DATA_HUNGER_LEVEL)));
        } else if (data.func_74764_b(DATA_FEED_IMMEDIATELY_WHEN_HURT)) {
            this.setFeedImmediatelyWhenHurt(data.func_74767_n(DATA_FEED_IMMEDIATELY_WHEN_HURT));
        }
        this.filterLogicContainer.handleMessage(data);
    }

    public FilterLogicContainer<FilterLogic> getFilterLogicContainer() {
        return this.filterLogicContainer;
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        ((FeedingUpgradeWrapper)this.upgradeWrapper).setFeedAtHungerLevel(hungerLevel);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_HUNGER_LEVEL, hungerLevel));
    }

    public HungerLevel getFeedAtHungerLevel() {
        return ((FeedingUpgradeWrapper)this.upgradeWrapper).getFeedAtHungerLevel();
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        ((FeedingUpgradeWrapper)this.upgradeWrapper).setFeedImmediatelyWhenHurt(feedImmediatelyWhenHurt);
        this.sendBooleanToServer(DATA_FEED_IMMEDIATELY_WHEN_HURT, feedImmediatelyWhenHurt);
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return ((FeedingUpgradeWrapper)this.upgradeWrapper).shouldFeedImmediatelyWhenHurt();
    }
}

