/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), backpackWrapper::getInventoryHandler);
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public ItemStack pickup(World world, ItemStack stack, boolean simulate) {
        ItemStack ret;
        if (this.isInLongCooldown(world)) {
            return stack;
        }
        if (!this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        int originalCount = stack.func_190916_E();
        if (originalCount == (ret = this.backpackWrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate)).func_190916_E()) {
            this.setCooldown(world, 40);
        }
        return ret;
    }

    private boolean isInLongCooldown(World world) {
        return this.getCooldownTime() - 10L > world.func_82737_E();
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        int cooldown;
        if (this.isInCooldown(world)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, world, pos) : 40;
        if (this.shouldPickupXp() && this.canFillBackpackWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, world, pos));
        }
        this.setCooldown(world, cooldown);
    }

    private boolean canFillBackpackWithXp() {
        return this.backpackWrapper.getFluidHandler().map(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)ModFluids.XP_STILL.get(), 1), IFluidHandler.FluidAction.SIMULATE) > 0).orElse(false);
    }

    private int pickupXpOrbs(@Nullable LivingEntity entity, World world, BlockPos pos) {
        List xpEntities = world.func_175647_a(ExperienceOrbEntity.class, new AxisAlignedBB(pos).func_186662_g((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 40;
        for (ExperienceOrbEntity xpOrb : xpEntities) {
            if (!xpOrb.func_70089_S() || this.canNotPickup((Entity)xpOrb, entity)) continue;
            if (!this.tryToFillTank(xpOrb, world)) break;
            cooldown = 10;
        }
        return cooldown;
    }

    private boolean tryToFillTank(ExperienceOrbEntity xpOrb, World world) {
        int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.func_70526_d());
        return this.backpackWrapper.getFluidHandler().map(fluidHandler -> {
            int amountAdded = fluidHandler.fill(new FluidStack((Fluid)ModFluids.XP_STILL.get(), amountToTransfer), IFluidHandler.FluidAction.EXECUTE);
            if (amountAdded > 0) {
                Vector3d pos = xpOrb.func_213303_ch();
                xpOrb.field_70530_e = 0;
                xpOrb.func_70106_y();
                if (amountToTransfer > amountAdded) {
                    world.func_217376_c((Entity)new ExperienceOrbEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable LivingEntity entity, World world, BlockPos pos) {
        List itemEntities = world.func_217394_a(EntityType.field_200765_E, new AxisAlignedBB(pos).func_186662_g((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 40;
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.func_70089_S() || !this.filterLogic.matchesFilter(itemEntity.func_92059_d()) || this.canNotPickup((Entity)itemEntity, entity) || !this.tryToInsertItem(itemEntity)) continue;
            cooldown = 10;
        }
        return cooldown;
    }

    private boolean isBlockedBySomething(Entity entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(Entity entity, @Nullable LivingEntity player) {
        if (this.isBlockedBySomething(entity)) {
            return true;
        }
        CompoundNBT data = entity.getPersistentData();
        return player != null ? data.func_74764_b(PREVENT_REMOTE_MOVEMENT) : data.func_74764_b(PREVENT_REMOTE_MOVEMENT) && !data.func_74764_b(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        ItemStack remaining = inventory.insertItem(stack, true);
        boolean insertedSomething = false;
        if (remaining.func_190916_E() != stack.func_190916_E()) {
            insertedSomething = true;
            remaining = inventory.insertItem(stack, false);
            itemEntity.func_92058_a(remaining);
        }
        return insertedSomething;
    }

    public void setPickupItems(boolean pickupItems) {
        NBTHelper.setBoolean(this.upgrade, "pickupItems", pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return NBTHelper.getBoolean(this.upgrade, "pickupItems").orElse(true);
    }

    public void setPickupXp(boolean pickupXp) {
        NBTHelper.setBoolean(this.upgrade, "pickupXp", pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return NBTHelper.getBoolean(this.upgrade, "pickupXp").orElse(true);
    }
}

