/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.XpHelper;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;

    protected XpPumpUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (entity != null && !(entity instanceof PlayerEntity) || this.isInCooldown(world)) {
            return;
        }
        if (entity == null) {
            AxisAlignedBB searchBox = new AxisAlignedBB(pos).func_186662_g(3.0);
            for (PlayerEntity player : world.func_217369_A()) {
                if (!searchBox.func_197744_e(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_())) continue;
                this.interactWithPlayer(player);
            }
        } else {
            PlayerEntity player = (PlayerEntity)entity;
            this.interactWithPlayer(player);
        }
        this.setCooldown(world, 5);
    }

    private void interactWithPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if (direction == AutomationDirection.INPUT) {
                if (level < player.field_71068_ca || level == player.field_71068_ca && player.field_71106_cc > 0.0f) {
                    this.tryFillTankWithPlayerExperience(player, (IBackpackFluidHandler)fluidHandler, level, false);
                }
            } else if (direction == AutomationDirection.OUTPUT && level > player.field_71068_ca) {
                this.tryGivePlayerExperienceFromTank(player, (IBackpackFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
        FluidStack toDrain = new FluidStack(this.getExperienceFluidFromHandlerOrDefault((IFluidHandler)fluidHandler), XpHelper.experienceToLiquid(maxXpPointsToGive));
        FluidStack drained = fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (!drained.isEmpty()) {
            player.func_195068_e(XpHelper.liquidToExperience(drained.getAmount()));
        }
    }

    private Fluid getExperienceFluidFromHandlerOrDefault(IFluidHandler fluidHandler) {
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            Fluid fluidInTank = fluidHandler.getFluidInTank(tank).getFluid();
            if (!fluidInTank.func_207185_a(ModFluids.EXPERIENCE_TAG)) continue;
            return fluidInTank;
        }
        return (Fluid)ModFluids.XP_STILL.get();
    }

    private void tryFillTankWithPlayerExperience(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
        FluidStack toFill = new FluidStack(this.getExperienceFluidFromHandlerOrDefault((IFluidHandler)fluidHandler), XpHelper.experienceToLiquid(maxXpPointsToTake));
        int filled = fluidHandler.fill(toFill, IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (filled > 0) {
            player.func_195068_e(-XpHelper.liquidToExperience(filled));
        }
    }

    public void takeLevelsFromPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IBackpackFluidHandler)fluidHandler, Math.max(player.field_71068_ca - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IBackpackFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IBackpackFluidHandler)fluidHandler, player.field_71068_ca + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IBackpackFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return NBTHelper.getEnumConstant(this.upgrade, "direction", AutomationDirection::fromName).orElse(AutomationDirection.INPUT);
    }

    public void setDirection(AutomationDirection direction) {
        NBTHelper.setEnumConstant(this.upgrade, "direction", direction);
        this.save();
    }

    public void setLevel(int level) {
        NBTHelper.setInteger(this.upgrade, "level", level);
        this.save();
    }

    public int getLevel() {
        return NBTHelper.getInt(this.upgrade, "level").orElse(10);
    }

    public void setLevelsToStore(int levelsToTake) {
        NBTHelper.setInteger(this.upgrade, "levelsToStore", levelsToTake);
        this.save();
    }

    public int getLevelsToStore() {
        return NBTHelper.getInt(this.upgrade, "levelsToStore").orElse(1);
    }

    public void setLevelsToTake(int levelsToGive) {
        NBTHelper.setInteger(this.upgrade, "levelsToTake", levelsToGive);
        this.save();
    }

    public int getLevelsToTake() {
        return NBTHelper.getInt(this.upgrade, "levelsToTake").orElse(1);
    }
}

