/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;

@MethodsReturnNonnullByDefault
public abstract class IngredientVanillaPlus
extends Ingredient {
    private final IIngredient crtIngredient;

    protected IngredientVanillaPlus(IIngredient crtIngredient, Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
        this.crtIngredient = crtIngredient;
    }

    protected IngredientVanillaPlus(IIngredient crtIngredient) {
        this(crtIngredient, Stream.of(new StackList((Collection)Arrays.stream(crtIngredient.getItems()).map(IItemStack::getInternal).collect(Collectors.toList()))));
    }

    public IIngredient getCrTIngredient() {
        return this.crtIngredient;
    }

    public boolean isSimple() {
        return false;
    }

    public abstract JsonElement func_200304_c();

    public abstract IIngredientSerializer<? extends IngredientVanillaPlus> getSerializer();

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.crtIngredient.matches(new MCItemStack(stack));
    }
}

