/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.util.StringUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class MethodHandleHelper {
    private MethodHandleHelper() {
    }

    public static MethodHandle linkMethod(Class<?> type, String methodName, Class<?> ... arguments) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method target = ObfuscationReflectionHelper.findMethod(type, (String)methodName, (Class[])arguments);
            return lookup.unreflect(target);
        }
        catch (ObfuscationReflectionHelper.UnableToFindMethodException e) {
            throw new UnableToLinkMethodHandleException("Method " + StringUtils.quoteAndEscape(methodName) + " was not found inside class " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new UnableToLinkMethodHandleException("Unable to access method " + StringUtils.quoteAndEscape(methodName), e);
        }
    }

    public static MethodHandle linkGetter(Class<?> type, String fieldName) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field target = ObfuscationReflectionHelper.findField(MethodHandleHelper.castToSuperExplicitly(type), (String)fieldName);
            return lookup.unreflectGetter(target);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
            throw new UnableToLinkMethodHandleException("Field " + StringUtils.quoteAndEscape(fieldName) + " was not found inside class " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new UnableToLinkMethodHandleException("Unable to access field " + StringUtils.quoteAndEscape(fieldName), e);
        }
    }

    public static MethodHandle linkSetter(Class<?> type, String fieldName) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field target = ObfuscationReflectionHelper.findField(MethodHandleHelper.castToSuperExplicitly(type), (String)fieldName);
            return lookup.unreflectSetter(target);
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
            throw new UnableToLinkMethodHandleException("Field " + StringUtils.quoteAndEscape(fieldName) + " was not found inside class " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new UnableToLinkMethodHandleException("Unable to access field " + StringUtils.quoteAndEscape(fieldName), e);
        }
    }

    public static <R> R invoke(MethodHandleInvoker<R> invoker) {
        try {
            return invoker.invoke();
        }
        catch (WrongMethodTypeException e) {
            throw new FailedInvocationException("Unable to invoke target method handle: check your arguments", e);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("Invoked method threw an exception", throwable);
        }
    }

    public static void invokeVoid(MethodHandleVoidInvoker invoker) {
        try {
            invoker.invoke();
        }
        catch (WrongMethodTypeException e) {
            throw new FailedInvocationException("Unable to invoke target method handle: check your arguments", e);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("Invoked method threw an exception", throwable);
        }
    }

    private static <T> Class<? super T> castToSuperExplicitly(Class<T> t) {
        return t;
    }

    public static interface MethodHandleVoidInvoker {
        public void invoke() throws Throwable;
    }

    public static interface MethodHandleInvoker<R> {
        public R invoke() throws Throwable;
    }

    public static final class FailedInvocationException
    extends RuntimeException {
        private FailedInvocationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class UnableToLinkMethodHandleException
    extends RuntimeException {
        private UnableToLinkMethodHandleException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

