/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.native_types;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.impl.registry.ZenClassRegistry;
import com.blamejared.crafttweaker.impl.native_types.NativeTypeRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.module.JavaNativeTypeConversionContext;
import org.openzen.zencode.java.module.converters.JavaNativeClassConverter;
import org.openzen.zencode.java.module.converters.JavaNativeHeaderConverter;
import org.openzen.zencode.java.module.converters.JavaNativeMemberConverter;
import org.openzen.zencode.java.module.converters.JavaNativePackageInfo;
import org.openzen.zencode.java.module.converters.JavaNativeTypeConverter;

class CrTJavaNativeClassConverter
extends JavaNativeClassConverter {
    private final ZenClassRegistry zenClassRegistry;

    public CrTJavaNativeClassConverter(JavaNativePackageInfo packageInfo, JavaNativeTypeConversionContext typeConversionContext, JavaNativeTypeConverter typeConverter, JavaNativeHeaderConverter headerConverter, JavaNativeMemberConverter memberConverter, ZenClassRegistry zenClassRegistry) {
        super(typeConverter, memberConverter, packageInfo, typeConversionContext, headerConverter);
        this.zenClassRegistry = zenClassRegistry;
    }

    @Override
    public String getNameForScripts(Class<?> cls) {
        if (this.getNativeTypeRegistry().hasInfoFor(cls)) {
            return this.getNativeTypeRegistry().getCrTNameFor(cls);
        }
        if (cls.getCanonicalName().startsWith("net.minecraft")) {
            CraftTweakerAPI.logger.trace("Minecraft Type referenced but not registered: " + cls.getCanonicalName());
        }
        return super.getNameForScripts(cls);
    }

    private NativeTypeRegistry getNativeTypeRegistry() {
        return this.zenClassRegistry.getNativeTypeRegistry();
    }

    @Override
    public boolean shouldLoadClass(Class<?> cls) {
        if (this.zenClassRegistry.isBlacklisted(cls)) {
            CraftTweakerAPI.logInfo("Not loading class because of blacklist: " + cls.getCanonicalName(), new Object[0]);
            return false;
        }
        return super.shouldLoadClass(cls);
    }

    @Override
    protected ZenCodeType.Constructor getConstructorAnnotation(Constructor<?> constructor) {
        return this.getNativeTypeRegistry().getMethodInfoFor(constructor).flatMap(it -> it.getAnnotation(ZenCodeType.Constructor.class)).orElseGet(() -> super.getConstructorAnnotation(constructor));
    }

    @Override
    protected <T extends Annotation> T getAnnotation(Method method, Class<T> cls) {
        return (T)this.getNativeTypeRegistry().getMethodInfoFor(method).flatMap(it -> it.getAnnotation(cls)).orElseGet(() -> super.getAnnotation(method, cls));
    }
}

