/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.misc;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.item.IItemStack;
import net.minecraft.block.ComposterBlock;
import net.minecraftforge.fml.LogicalSide;

public class ActionSetCompostable
implements IUndoableAction {
    private final IItemStack stack;
    private final float newValue;
    private final float oldValue;

    public ActionSetCompostable(IItemStack stack, float newValue) {
        this.stack = stack;
        this.newValue = newValue;
        this.oldValue = ComposterBlock.field_220299_b.getOrDefault((Object)stack.getInternal().func_77973_b(), -1.0f);
    }

    @Override
    public void apply() {
        if (this.newValue <= 0.0f) {
            ComposterBlock.field_220299_b.remove((Object)this.stack.getInternal().func_77973_b());
        } else {
            ComposterBlock.field_220299_b.put((Object)this.stack.getInternal().func_77973_b(), this.newValue);
        }
    }

    @Override
    public String describe() {
        return "Setting Composter value of: " + this.stack.getCommandString() + ", to: " + this.newValue + ", from: " + this.oldValue;
    }

    @Override
    public void undo() {
        if (this.oldValue <= 0.0f) {
            ComposterBlock.field_220299_b.remove((Object)this.stack.getInternal().func_77973_b());
        } else {
            ComposterBlock.field_220299_b.put((Object)this.stack.getInternal().func_77973_b(), this.oldValue);
        }
    }

    @Override
    public String describeUndo() {
        return "Undoing setting Composter value of: " + this.stack.getCommandString() + ", to: " + this.newValue + ", reverting to: " + this.oldValue;
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return this.shouldApplySingletons();
    }
}

