/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByName;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;

public class ActionReplaceRecipe
extends ActionRecipeBase {
    private final Supplier<ActionAddRecipe> addRecipe;
    private final ActionRemoveRecipeByName removeRecipe;
    private final ResourceLocation oldName;
    private final Supplier<ResourceLocation> newName;

    public ActionReplaceRecipe(IRecipeManager manager, Function<ResourceLocation, ResourceLocation> nameGenerator, IRecipe<?> oldRecipe, Function<ResourceLocation, IRecipe<?>> recipeCreator) {
        super(manager);
        this.oldName = oldRecipe.func_199560_c();
        this.newName = Lazy.concurrentOf(() -> (ResourceLocation)nameGenerator.apply(this.oldName));
        this.removeRecipe = new ActionRemoveRecipeByName(manager, this.oldName);
        this.addRecipe = () -> new ActionAddRecipe(manager, (IRecipe)recipeCreator.apply(this.newName.get()));
    }

    @Override
    public void apply() {
        this.removeRecipe.apply();
        this.addRecipe.get().apply();
    }

    @Override
    public String describe() {
        return String.format("- Replacing \"%s\" recipe with name \"%s\"%s", this.getManager().getBracketResourceLocation(), this.oldName, this.oldName.equals((Object)this.newName.get()) ? "" : String.format(", renaming it to \"%s\"", this.newName.get()));
    }
}

