/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes.generic;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionWholeRegistryBase;
import com.blamejared.crafttweaker.impl.managers.RecipeManagerWrapper;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;

public abstract class ActionRemoveGenericRecipeBase
extends ActionWholeRegistryBase {
    @Override
    public void apply() {
        TreeMap<String, Integer> numberOfRemovedRecipesByType = new TreeMap<String, Integer>();
        int numberOfRemovedRecipes = 0;
        Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipesByType = this.getRecipesByType();
        for (IRecipeType<?> recipeType : recipesByType.keySet()) {
            int removedRecipes = this.applyToRegistry(recipesByType.get(recipeType));
            if (removedRecipes <= 0) continue;
            String commandString = new RecipeManagerWrapper(recipeType).getCommandString();
            numberOfRemovedRecipesByType.put(commandString, removedRecipes);
            numberOfRemovedRecipes += removedRecipes;
        }
        int numberOfRecipeTypes = numberOfRemovedRecipesByType.size();
        String recipeTypeList = this.makeRecipeList(numberOfRemovedRecipesByType);
        CraftTweakerAPI.logInfo("Removed %s recipes registered in these %s recipe managers: %s", numberOfRemovedRecipes, numberOfRecipeTypes, recipeTypeList);
    }

    private int applyToRegistry(Map<ResourceLocation, IRecipe<?>> registry) {
        int initialSize = registry.size();
        registry.values().removeIf(this::shouldRemove);
        return initialSize - registry.size();
    }

    protected abstract boolean shouldRemove(IRecipe<?> var1);
}

