/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.ISuggestionProvider;

public enum CTRecipeTypeArgument implements ArgumentType<IRecipeManager>
{
    INSTANCE;

    private static final Collection<String> EXAMPLES;
    private static final SimpleCommandExceptionType INVALID_STRING;
    private static final DynamicCommandExceptionType UNKNOWN_RECIPE_TYPE;
    private static final Pattern RECIPE_TYPE_PATTERN;

    public IRecipeManager parse(StringReader reader) throws CommandSyntaxException {
        Matcher matcher = RECIPE_TYPE_PATTERN.matcher(reader.getRemaining());
        if (!matcher.find()) {
            throw INVALID_STRING.createWithContext((ImmutableStringReader)reader);
        }
        String location = matcher.group(1);
        reader.setCursor(reader.getCursor() + matcher.group(0).length());
        try {
            return RecipeTypeBracketHandler.getRecipeManager(location);
        }
        catch (IllegalArgumentException e) {
            throw UNKNOWN_RECIPE_TYPE.createWithContext((ImmutableStringReader)reader, (Object)location);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197013_a(RecipeTypeBracketHandler.getManagerInstances().stream().map(IRecipeManager::getCommandString), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static {
        EXAMPLES = Lists.newArrayList((Object[])new String[]{"<recipetype:minecraft:crafting>", "<recipetype:minecraft:blasting>"});
        INVALID_STRING = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid String"));
        UNKNOWN_RECIPE_TYPE = new DynamicCommandExceptionType(o -> new LiteralMessage("Unknown Recipe Type: " + o));
        RECIPE_TYPE_PATTERN = Pattern.compile("^<recipetype:(\\w+:\\w+)>");
    }
}

