/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker;

import com.blamejared.crafttweaker.api.text.FormattedTextComponent;
import com.blamejared.crafttweaker.impl.commands.CommandImpl;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;

public final class HelpCommand {
    private static final int COMMANDS_PER_PAGE = 4;

    private HelpCommand() {
    }

    public static void registerHelpCommand(Supplier<Map<String, CommandImpl>> commandsGetter, Consumer<LiteralArgumentBuilder<CommandSource>> registerCustomCommand) {
        Map<String, CommandImpl> commands = commandsGetter.get();
        registerCustomCommand.accept((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)Commands.func_197057_a((String)"help").executes(context -> HelpCommand.executeHelp(commands, (CommandContext<CommandSource>)context, 1))).then(Commands.func_197056_a((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)(commands.size() / 4 + 1))).executes(context -> HelpCommand.executeHelp(commands, (CommandContext<CommandSource>)context, (Integer)context.getArgument("page", Integer.TYPE)))));
    }

    private static int executeHelp(Map<String, CommandImpl> commands, CommandContext<CommandSource> context, int helpPageNumber) {
        CommandSource source = (CommandSource)context.getSource();
        ArrayList<String> keys = new ArrayList<String>(commands.keySet());
        int highestPageIndex = keys.size() / 4;
        int shownPageIndex = MathHelper.func_76125_a((int)(helpPageNumber - 1), (int)0, (int)highestPageIndex);
        int startCommandIndex = shownPageIndex * 4;
        int endCommandIndex = Math.min(startCommandIndex + 4, keys.size());
        for (int i = startCommandIndex; i < endCommandIndex; ++i) {
            CommandImpl command = commands.get(keys.get(i));
            FormattedTextComponent message = new FormattedTextComponent("/ct %s", command.getName());
            source.func_197030_a((ITextComponent)CommandUtilities.run((TextComponent)message, message.func_150261_e()), true);
            source.func_197030_a((ITextComponent)new FormattedTextComponent("- %s", CommandUtilities.color(command.getDescription(), TextFormatting.DARK_AQUA)), true);
        }
        source.func_197030_a((ITextComponent)new FormattedTextComponent("Page %s of %d", shownPageIndex + 1, highestPageIndex + 1), true);
        return 0;
    }
}

