/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.conditions;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.impl.ingredients.conditions.serializer.ConditionDamagedAtMostSerializer;

public class ConditionDamagedAtMost<T extends IIngredient>
implements IIngredientCondition<T> {
    private final int maxDamage;

    public ConditionDamagedAtMost(int maxDamage) {
        this.maxDamage = maxDamage;
    }

    @Override
    public boolean matches(IItemStack stack) {
        return stack.getDamage() <= this.maxDamage;
    }

    @Override
    public boolean ignoresDamage() {
        return true;
    }

    @Override
    public String getCommandString(IIngredient ingredient) {
        return String.format("%s.onlyDamagedAtMost(%s)", ingredient.getCommandString(), this.maxDamage);
    }

    @Override
    public IIngredientConditionSerializer getSerializer() {
        return ConditionDamagedAtMostSerializer.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionDamagedAtMost that = (ConditionDamagedAtMost)o;
        return this.maxDamage == that.maxDamage;
    }

    public int hashCode() {
        return this.maxDamage;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }
}

