/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.ingredient.PartialNBTIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.util.EnchantmentUtil;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.MCItemStackMutable")
@Document(value="vanilla/api/items/MCItemStackMutable")
public class MCItemStackMutable
implements IItemStack {
    private final ItemStack internal;

    public MCItemStackMutable(ItemStack internal) {
        this.internal = internal;
    }

    @Override
    public IItemStack copy() {
        return new MCItemStackMutable(this.getInternal().func_77946_l());
    }

    @Override
    public IItemStack setDisplayName(String name) {
        this.getInternal().func_200302_a((ITextComponent)new StringTextComponent(name));
        return this;
    }

    @Override
    public IItemStack withDisplayName(MCTextComponent text) {
        this.getInternal().func_200302_a(text.getInternal());
        return this;
    }

    @Override
    public IItemStack setAmount(int amount) {
        this.getInternal().func_190920_e(amount);
        return this;
    }

    @Override
    public IItemStack grow(int amount) {
        this.getInternal().func_190917_f(amount);
        return this;
    }

    @Override
    public IItemStack shrink(int amount) {
        this.getInternal().func_190918_g(amount);
        return this;
    }

    @Override
    public IItemStack withDamage(int damage) {
        this.getInternal().func_196085_b(damage);
        return this;
    }

    @Override
    public IItemStack withAttributeModifier(Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlotType[] slotTypes, boolean preserveDefaults) {
        for (EquipmentSlotType slotType : slotTypes) {
            if (preserveDefaults) {
                AttributeUtil.addAttributeModifier(this.getInternal(), attribute, new AttributeModifier(UUID.fromString(uuid), name, value, operation), slotType);
                continue;
            }
            this.getInternal().func_185129_a(attribute, new AttributeModifier(UUID.fromString(uuid), name, value, operation), slotType);
        }
        return this;
    }

    @Override
    public IItemStack withAttributeModifier(Attribute attribute, String name, double value, AttributeModifier.Operation operation, EquipmentSlotType[] slotTypes, boolean preserveDefaults) {
        for (EquipmentSlotType slotType : slotTypes) {
            if (preserveDefaults) {
                AttributeUtil.addAttributeModifier(this.getInternal(), attribute, new AttributeModifier(name, value, operation), slotType);
                continue;
            }
            this.getInternal().func_185129_a(attribute, new AttributeModifier(name, value, operation), slotType);
        }
        return this;
    }

    @Override
    public IItemStack withTag(IData tag) {
        if (!(tag instanceof MapData)) {
            tag = new MapData(tag.asMap());
        }
        this.getInternal().func_77982_d(((MapData)tag).getInternal());
        return this;
    }

    @Override
    public IItemStack withoutTag() {
        this.getInternal().func_77982_d(null);
        return this;
    }

    @Override
    public String getCommandString() {
        return ItemStackHelper.getCommandString(this.getInternal(), true);
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public ItemStack getImmutableInternal() {
        return this.internal.func_77946_l();
    }

    @Override
    public int getDamage() {
        return this.getInternal().func_77952_i();
    }

    @Override
    public IItemStack setEnchantments(Map<Enchantment, Integer> enchantments) {
        EnchantmentUtil.setEnchantments(enchantments, this.getInternal());
        return this;
    }

    @Override
    public IItemStack withEnchantment(Enchantment enchantment, int level) {
        Map<Enchantment, Integer> enchantments = this.getEnchantments();
        enchantments.put(enchantment, level);
        EnchantmentUtil.setEnchantments(enchantments, this.getInternal());
        return this;
    }

    @Override
    public IItemStack removeEnchantment(Enchantment enchantment) {
        Map<Enchantment, Integer> enchantments = this.getEnchantments();
        enchantments.remove(enchantment);
        EnchantmentUtil.setEnchantments(enchantments, this.getInternal());
        return this;
    }

    @Override
    public IItemStack mutable() {
        return this;
    }

    @Override
    public IItemStack asImmutable() {
        return new MCItemStack(this.getInternal().func_77946_l());
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        if (this.getInternal().func_190926_b()) {
            return Ingredient.field_193370_a;
        }
        if (!this.getInternal().func_77942_o()) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getImmutableInternal()});
        }
        return new PartialNBTIngredient(this.getImmutableInternal());
    }

    public String toString() {
        return this.getCommandString();
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this};
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStack thatStack = ((MCItemStackMutable)o).getInternal();
        ItemStack thisStack = this.getInternal();
        if (thisStack.func_190926_b()) {
            return thatStack.func_190926_b();
        }
        if (thisStack.func_190916_E() != thatStack.func_190916_E()) {
            return false;
        }
        if (!Objects.equals(thisStack.func_77973_b(), thatStack.func_77973_b())) {
            return false;
        }
        if (!Objects.equals(thisStack.func_77978_p(), thatStack.func_77978_p())) {
            return false;
        }
        return thisStack.areCapsCompatible((CapabilityProvider)thatStack);
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().func_190916_E(), this.getInternal().func_77973_b(), this.getInternal().func_77978_p());
    }
}

