/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.impl.loot.conditions.CTLootConditionBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.mojang.datafixers.util.Pair;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class LootConditionManager {
    private static final Map<Class<? extends ILootConditionTypeBuilder>, Function<CTLootConditionBuilder, ? extends ILootConditionTypeBuilder>> BUILDERS = new HashMap<Class<? extends ILootConditionTypeBuilder>, Function<CTLootConditionBuilder, ? extends ILootConditionTypeBuilder>>();

    public static void handleBuilderRegistration() {
        BUILDERS.clear();
        CraftTweakerRegistry.getZenClassRegistry().getImplementationsOf(ILootConditionTypeBuilder.class).stream().map(LootConditionManager::make).filter(Objects::nonNull).forEach(LootConditionManager::register);
    }

    public static <T extends ILootConditionTypeBuilder> T get(CTLootConditionBuilder builder, Class<T> token) {
        return (T)Objects.requireNonNull(BUILDERS.get(token), () -> "No loot condition builder for type '" + token.getName() + "' was registered!").apply(builder);
    }

    private static <T extends ILootConditionTypeBuilder> Pair<Class<T>, Function<CTLootConditionBuilder, T>> make(Class<T> clazz) {
        boolean hasBothConstructors;
        Field instanceField = LootConditionManager.findInstanceField(clazz);
        Pair<Constructor<T>, Constructor<T>> constructors = LootConditionManager.findConstructors(clazz);
        boolean hasInstance = instanceField != null;
        boolean hasConstructor = constructors.getFirst() != null || constructors.getSecond() != null;
        boolean bl = hasBothConstructors = constructors.getFirst() != null && constructors.getSecond() != null;
        if (hasInstance && hasConstructor) {
            CraftTweakerAPI.logWarning("Identified both 'INSTANCE' field and a valid constructor for condition '%s': INSTANCE will take precedence", clazz.getName());
        } else if (!hasInstance && hasBothConstructors) {
            CraftTweakerAPI.logWarning("Identified two valid constructors for condition '%s': no-arg will take precedence", clazz.getName());
        } else if (!hasInstance && !hasConstructor) {
            CraftTweakerAPI.logError("Condition '%s' does not specify a valid constructor nor an instance field! This is invalid", clazz.getName());
            return null;
        }
        return Pair.of(clazz, LootConditionManager.make(instanceField, (Constructor)constructors.getFirst(), (Constructor)constructors.getSecond()));
    }

    private static <T extends ILootConditionTypeBuilder> Field findInstanceField(Class<T> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(it -> Modifier.isStatic(it.getModifiers())).filter(it -> !Modifier.isPrivate(it.getModifiers())).filter(it -> "INSTANCE".equals(it.getName())).peek(it -> it.setAccessible(true)).findFirst().orElse(null);
    }

    private static <T extends ILootConditionTypeBuilder> Pair<Constructor<T>, Constructor<T>> findConstructors(Class<T> clazz) {
        Constructor<?> noArg = null;
        Constructor<?> singleArg = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Constructor<?> typedConstructor = constructor;
            if (Modifier.isPrivate(typedConstructor.getModifiers())) continue;
            if (typedConstructor.getParameterCount() == 0) {
                noArg = typedConstructor;
                continue;
            }
            if (typedConstructor.getParameterCount() != 1 || typedConstructor.getParameters()[0].getType() != CTLootConditionBuilder.class) continue;
            singleArg = typedConstructor;
        }
        if (noArg != null) {
            noArg.setAccessible(true);
        }
        if (singleArg != null) {
            singleArg.setAccessible(true);
        }
        return Pair.of((Object)noArg, (Object)singleArg);
    }

    private static <T extends ILootConditionTypeBuilder> Function<CTLootConditionBuilder, T> make(Field instance, Constructor<T> noArg, Constructor<T> singleArg) {
        if (instance != null) {
            return LootConditionManager.ignoring(() -> (ILootConditionTypeBuilder)LamdbaExceptionUtils.uncheck(() -> (ILootConditionTypeBuilder)instance.get(null)));
        }
        if (noArg != null) {
            return LootConditionManager.ignoring(() -> (ILootConditionTypeBuilder)LamdbaExceptionUtils.uncheck(() -> (ILootConditionTypeBuilder)noArg.newInstance(new Object[0])));
        }
        return builder -> (ILootConditionTypeBuilder)LamdbaExceptionUtils.uncheck(() -> (ILootConditionTypeBuilder)singleArg.newInstance(builder));
    }

    private static <T extends ILootConditionTypeBuilder> Function<CTLootConditionBuilder, T> ignoring(Supplier<T> maker) {
        return ignore -> (ILootConditionTypeBuilder)maker.get();
    }

    private static <T extends ILootConditionTypeBuilder> void register(Pair<Class<T>, Function<CTLootConditionBuilder, T>> pair) {
        Class typeToken = (Class)pair.getFirst();
        Function creator = (Function)pair.getSecond();
        if (BUILDERS.containsKey(typeToken)) {
            throw new IllegalStateException("A builder for the given type '" + typeToken.getName() + "' was already registered");
        }
        BUILDERS.put(typeToken, creator);
        CraftTweakerAPI.logDebug("Successfully registered loot condition type builder for '%s' as '%s'", typeToken, creator);
    }
}

