/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.RandomChanceWithLooting")
@Document(value="vanilla/api/loot/conditions/vanilla/RandomChanceWithLooting")
public final class RandomChanceWithLootingLootConditionBuilder
implements ILootConditionTypeBuilder {
    private float chance;
    private float lootingMultiplier;

    RandomChanceWithLootingLootConditionBuilder() {
    }

    @ZenCodeType.Method
    public RandomChanceWithLootingLootConditionBuilder withChance(float chance) {
        this.chance = chance;
        return this;
    }

    @ZenCodeType.Method
    public RandomChanceWithLootingLootConditionBuilder withLootingMultiplier(float lootingMultiplier) {
        this.lootingMultiplier = lootingMultiplier;
        return this;
    }

    @Override
    public ILootCondition finish() {
        if ((double)this.chance >= 1.0) {
            CraftTweakerAPI.logWarning("Chance in a 'RandomChanceWithLooting' condition is a number that is equal to or higher than 1.0 (currently: %f): this condition will always match!", Float.valueOf(this.chance));
        } else if ((double)this.chance <= 0.0) {
            CraftTweakerAPI.logWarning("Chance in a 'RandomChanceWithLooting' condition is a number that is equal to or lower than 0.0 (currently: %f): this condition will never match!", Float.valueOf(this.chance));
        }
        if ((double)this.lootingMultiplier == 0.0) {
            CraftTweakerAPI.logWarning("Looting modifier in a 'RandomChanceWithLooting' condition is 0.0: this condition is equivalent to a 'RandomChance' condition", new Object[0]);
        }
        return context -> context.func_216032_b().nextFloat() < this.chance + (float)context.getLootingModifier() * this.lootingMultiplier;
    }
}

