/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.StatePropertiesPredicate;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.fluid.Fluid;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.FluidPredicate")
@Document(value="vanilla/api/predicate/FluidPredicate")
public final class FluidPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.FluidPredicate> {
    private Fluid fluid;
    private MCTag<Fluid> fluidTag;
    private StatePropertiesPredicate states = new StatePropertiesPredicate();

    public FluidPredicate() {
        super(net.minecraft.advancements.criterion.FluidPredicate.field_226643_a_);
    }

    @ZenCodeType.Method
    public FluidPredicate withFluid(Fluid fluid) {
        this.fluid = fluid;
        return this;
    }

    @ZenCodeType.Method
    public FluidPredicate withFluidTag(MCTag<Fluid> fluidTag) {
        this.fluidTag = fluidTag;
        return this;
    }

    @ZenCodeType.Method
    public FluidPredicate withStatePropertiesPredicate(Consumer<StatePropertiesPredicate> builder) {
        StatePropertiesPredicate predicate = new StatePropertiesPredicate();
        builder.accept(predicate);
        this.states = predicate;
        return this;
    }

    @Override
    public boolean isAny() {
        return this.fluid == null && this.fluidTag == null && this.states.isAny();
    }

    @Override
    public net.minecraft.advancements.criterion.FluidPredicate toVanilla() {
        if (this.fluidTag != null && this.fluid != null) {
            CraftTweakerAPI.logWarning("'FluidPredicate' specifies both a fluid and a tag: the second will take precedence", new Object[0]);
        }
        return new net.minecraft.advancements.criterion.FluidPredicate(this.fluidTag != null ? CraftTweakerHelper.getITag(this.fluidTag) : null, this.fluid, (net.minecraft.advancements.criterion.StatePropertiesPredicate)this.states.toVanillaPredicate());
    }
}

